% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/editCluster.R
\name{editCluster}
\alias{editCluster}
\alias{editClusterRES}
\title{Edit an existing cluster}
\usage{
editCluster(
  area,
  cluster_name,
  ...,
  list_pollutants = NULL,
  time_series = NULL,
  prepro_data = NULL,
  prepro_modulation = NULL,
  add_prefix = TRUE,
  opts = antaresRead::simOptions()
)

editClusterRES(
  area,
  cluster_name,
  ...,
  time_series = NULL,
  add_prefix = TRUE,
  opts = antaresRead::simOptions()
)
}
\arguments{
\item{area}{The area where to create the cluster.}

\item{cluster_name}{Name for the cluster, it will prefixed by area name, unless you set \code{add_prefix = FALSE}.}

\item{...}{Parameters to write in the Ini file. Careful!
Some parameters must be set as \code{integers} to avoid warnings in Antares, for example,
to set \code{unitcount}, you'll have to use \code{unitcount = 1L}.}

\item{list_pollutants}{\code{list} named with specific pollutants (only for Antares version >= 860)}

\item{time_series}{the "ready-made" 8760-hour time-series available for simulation purposes.}

\item{prepro_data}{Pre-process data, a \code{data.frame} or \code{matrix},
default is a matrix with 365 rows and 6 columns.}

\item{prepro_modulation}{Pre-process modulation, a \code{data.frame} or \code{matrix},
if specified, must have 8760 rows and 1 or 4 columns.}

\item{add_prefix}{If \code{TRUE} (the default), \code{cluster_name} will be prefixed by area name.}

\item{opts}{List of simulation parameters returned by the function
\code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath()}}}
}
\value{
An updated list containing various information about the simulation.
}
\description{
\ifelse{html}{\figure{badge_api_ok.svg}{options: alt='Antares API OK'}}{Antares API: \strong{OK}} (thermal clusters only)

Edit parameters, pre-process data and time series of an existing cluster, thermal or RES (renewable energy source).
}
\note{
Parameter \code{list_pollutants} is only available for Antares studies >= v8.6.0.

You must provide named \code{list} (numerical values or NULL ) :

\code{list( "nh3"= 0.25, "nox"= 0.45, "pm2_5"= 0.25,   "pm5"= 0.25, "pm10"= 0.25, "nmvoc"= 0.25, "so2"= 0.25,  "op1"= 0.25, "op2"= 0.25, "op3"= 0.25,   "op4"= 0.25, "op5"= NULL, "co2"= NULL)}
}
\examples{
\dontrun{

# Update only nominalCapacity for an existing cluster
editCluster(
  area = "myarea", 
  cluster_name = "mycluster", 
  nominalcapacity = 10600.000
)

}
}
\seealso{
\code{\link[=createCluster]{createCluster()}} or \code{\link[=createClusterRES]{createClusterRES()}} to create new clusters, \code{\link[=removeCluster]{removeCluster()}} or \code{\link[=removeClusterRES]{removeClusterRES()}} to remove clusters.
}
