% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence_classification.R
\name{sequence_classification}
\alias{sequence_classification}
\title{Leverage sequences to classify images}
\usage{
sequence_classification(
  animals,
  empty,
  predictions_raw,
  classes,
  station_col = "station",
  empty_class = "",
  human_class = "",
  vehicle_class = "",
  sort_columns = NULL,
  file_col = "filepath",
  maxdiff = 60
)
}
\arguments{
\item{animals}{sub-selection of all images that contain MD animals}

\item{empty}{optional, data frame non-animal images (empty, human and vehicle) that will be merged back with animal imagages}

\item{predictions_raw}{data frame of prediction probabilities from the classifySpecies function}

\item{classes}{class list associated with classifier model}

\item{station_col}{a column in the animals and empty data frame that indicates the camera or camera station}

\item{empty_class}{a string indicating the class that should be considered 'Empty'}

\item{human_class}{a string indicating the class that should be considered 'Human'}

\item{vehicle_class}{a string indicating the class that should be considered 'Vehicle'}

\item{sort_columns}{optional sort order. The default is 'station_column' and datetime.}

\item{file_col}{a field indicating a single record. The default is FilePath for single images/videos.}

\item{maxdiff}{maximum difference between images in seconds to be included in a sequence, defaults to 60}
}
\value{
data frame with predictions and confidence values for animals and empty images
}
\description{
This function applies image classifications at a sequence level by leveraging
information from multiple images. A sequence is defined as all images at the same
camera/station where the time between consecutive images is <=maxdiff. This can improve
classification accuracy, but assumes that only one species is present in each sequence.
If you regularly expect multiple species to occur in an image or sequence don't use this function.
}
\details{
This function retains "Empty" classification even if other images within the
sequence are predicted to contain animals.
Classification confidence is weighted by MD confidence.
}
\examples{
\dontrun{
predictions_raw <-classify(classifier, images, resize_width=456, resize_height=456)
animals <- get_animals(images)
empty <- get_empty(images)
animals <- sequence_classification(animals, empty, predictions_raw, classes,
                                   station_column="StationID",
                                   empty_class = "Empty",
                                   sort_columns = c("StationID", "DateTime"),
                                   maxdiff=60)
}
}
