% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/c14_curve.R
\docType{methods}
\name{c14_curve}
\alias{c14_curve}
\alias{c14_curve-method}
\alias{c14_curve,character-method}
\alias{c14_curve,CalibratedAges-method}
\title{14C Calibration Curve}
\usage{
c14_curve(name, ...)

\S4method{c14_curve}{character}(name)

\S4method{c14_curve}{CalibratedAges}(name)
}
\arguments{
\item{name}{A \code{\link{character}} vector naming calibration curves (see details).}

\item{...}{Currently not used.}
}
\value{
A \code{list} of three-column \code{\link{data.frame}}:
\tabular{ll}{
\code{CALBP} \tab Calibrated age BP            \cr
\code{AGE}   \tab Uncalibrated radiocarbon age \cr
\code{ERROR} \tab Standard deviation           \cr
}
}
\description{
14C Calibration Curve
}
\details{
The following calibration curves are available:

\tabular{ll}{
\strong{Curve}    \tab \strong{Reference} \cr
\code{intcal04}   \tab Reimer et al. 2004 \cr
\code{intcal09}   \tab Reimer et al. 2009 \cr
\code{intcal13}   \tab Reimer et al. 2013 \cr
\code{intcal20}   \tab Reimer et al. 2020 \cr
\code{marine04}   \tab Hughen et al. 2004 \cr
\code{marine09}   \tab Reimer et al. 2009 \cr
\code{marine13}   \tab Reimer et al. 2013 \cr
\code{marine20}   \tab Heaton et al. 2020 \cr
\code{shcal04}    \tab McCormac et al. 2004 \cr
\code{shcal13}    \tab Hogg et al. 2013 \cr
\code{shcal20}    \tab Hogg et al. 2020 \cr
}
}
\examples{
## IntCal20
intcal20 <- c14_curve("intcal20")
head(intcal20[[1]])

## IntCal
intcal <- c14_curve(c("intcal09", "intcal13", "intcal20"))
lapply(X = intcal, FUN = head)
}
\references{
Heaton, Timothy J, Peter Köhler, Martin Butzin, Edouard Bard, Ron W Reimer,
William E N Austin, Christopher Bronk Ramsey, et al. (2020). Marine20 The
Marine Radiocarbon Age Calibration Curve (0-55,000 Cal BP).
\emph{Radiocarbon}, 62(4): 779-820. \doi{10.1017/RDC.2020.68}.

Hogg, Alan G, Timothy J Heaton, Quan Hua, Jonathan G Palmer, Chris SM
Turney, John Southon, Alex Bayliss, et al. (2020). SHCal20 Southern
Hemisphere Calibration, 0-55,000 Years Cal BP. \emph{Radiocarbon}, 62(4): 759-78.
\doi{10.1017/RDC.2020.59}.

Hogg, Alan G, Quan Hua, Paul G Blackwell, Mu Niu, Caitlin E Buck, Thomas P
Guilderson, Timothy J Heaton, et al. (2013). SHCal13 Southern Hemisphere
Calibration, 0-50,000 Years Cal BP. \emph{Radiocarbon}, 55(4): 1889-1903.
\doi{10.2458/azu_js_rc.55.16783}.

Hua, Quan, and Mike Barbetti (2004). Review of Tropospheric Bomb 14C Data
for Carbon Cycle Modeling and Age Calibration Purposes. \emph{Radiocarbon},
46(3): 1273-1298. \doi{10.1017/S0033822200033142}.

Hua, Quan, Mike Barbetti, and Andrzej Z Rakowski (2013). Atmospheric
Radiocarbon for the Period 1950-2010. \emph{Radiocarbon}, 55(4): 2059‑2072.
\doi{10.2458/azu_js_rc.v55i2.16177}.

Hua, Quan, Jocelyn C Turnbull, Guaciara M Santos, Andrzej Z Rakowski,
Santiago Ancapichún, Ricardo De Pol-Holz, Samuel Hammer, et al. (2022).
Atmospheric Radiocarbon for the Period 1950-2019. \emph{Radiocarbon},
64(4): 723‑745. \doi{10.1017/RDC.2021.95}.

Hughen, K., S. Lehman, J. Southon, J. Overpeck, O. Marchal, C. Herring,
and J. Turnbull (2004). 14C Activity and Global Carbon Cycle Changes over
the Past 50,000 Years. \emph{Science}, 303(5655): 202‑207.
\doi{10.1126/science.1090300}.

Hughen, Konrad A, Mike G L Baillie, Edouard Bard, J Warren Beck, Chanda J H
Bertrand, Paul G Blackwell, Caitlin E Buck, et al. (2004). Marine04 Marine
Radiocarbon Age Calibration, 0-26 cal kyr BP. \emph{Radiocarbon},
46(3): 1059‑1086. \doi{10.1017/S0033822200033002}.

Kueppers, Lara M., John Southon, Paul Baer, and John Harte (2004). Dead Wood
Biomass and Turnover Time, Measured by Radiocarbon, along a Subalpine
Elevation Gradient. \emph{Oecologia}, 141(4): 641‑651.
\doi{10.1007/s00442-004-1689-x}.

McCormac, F G, A G Hogg, P G Blackwell, C E Buck, T F G Higham, and P J
Reimer (2004). Shcal04 Southern Hemisphere Calibration, 0-11.0 cal kyr BP.
\emph{Radiocarbon}, 46(3): 1087‑1092. \doi{10.1017/S0033822200033014}.

Reimer, P J, M G L Baillie, E Bard, A Bayliss, J W Beck, P G Blackwell,
C Bronk Ramsey, et al. (2009). IntCal09 and Marine09 Radiocarbon Age
Calibration Curves, 0-50,000 Years cal BP. \emph{Radiocarbon}, 51(4): 1111‑1150.
\doi{10.1017/S0033822200034202}.

Reimer, Paula J, William E N Austin, Edouard Bard, Alex Bayliss, Paul G
Blackwell, Christopher Bronk Ramsey, Martin Butzin, et al. (2020).
The IntCal20 Northern Hemisphere Radiocarbon Age Calibration Curve
(0-55 cal kBP). \emph{Radiocarbon}, 62(4): 725‑757. \doi{10.1017/RDC.2020.41}.

Reimer, Paula J, Mike G L Baillie, Edouard Bard, Alex Bayliss,
J Warren Beck, Chanda J H Bertrand, Paul G Blackwell, et al. (2004).
Intcal04 Terrestrial Radiocarbon Age Calibration, 0-26 cal kyr BP.
\emph{Radiocarbon}, 46(3): 1029‑1058. \doi{10.1017/S0033822200032999}.

Reimer, Paula J, Edouard Bard, Alex Bayliss, J Warren Beck, Paul G
Blackwell, Christopher Bronk Ramsey, Caitlin E Buck, et al. (2013).
IntCal13 and Marine13 Radiocarbon Age Calibration Curves 0-50,000
Years cal BP. \emph{Radiocarbon}, 55(4): 1869‑1887.
\doi{10.2458/azu_js_rc.55.16947}.

Stuiver, Minze, Paula J. Reimer, Edouard Bard, J. Warren Beck, G. S. Burr,
Konrad A. Hughen, Bernd Kromer, Gerry McCormac, Johannes van der Plicht, and
Marco Spurk (1998). INTCAL98 Radiocarbon Age Calibration, 24,000-0 cal BP.
\emph{Radiocarbon}, 40(3): 1041‑1083. \doi{10.1017/S0033822200019123}.

Stuiver, Minze, Paula J. Reimer, and Thomas F. Braziunas. (1998).
High-Precision Radiocarbon Age Calibration for Terrestrial and Marine
Samples. \emph{Radiocarbon}, 40(3): 1127‑1151. \doi{10.1017/S0033822200019172}.
}
\seealso{
Other radiocarbon tools: 
\code{\link{F14C}},
\code{\link{c14_calibrate}()},
\code{\link{c14_combine}()},
\code{\link{c14_ensemble}()},
\code{\link{c14_plot}},
\code{\link{c14_sample}()},
\code{\link{c14_spd}()},
\code{\link{c14_uncalibrate}()},
\code{\link{rec_plot}}
}
\author{
N. Frerebeau
}
\concept{radiocarbon tools}
