% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hr_kde.R
\name{hr_kde_ref_scaled}
\alias{hr_kde_ref_scaled}
\title{Select a bandwidth for Kernel Density Estimation}
\usage{
hr_kde_ref_scaled(
  x,
  range = hr_kde_ref(x)[1] * c(0.01, 1),
  trast = make_trast(x),
  num.of.parts = 1,
  levels = 0.95,
  tol = 0.1,
  max.it = 500L
)
}
\arguments{
\item{x}{A \verb{track_xy*}.}

\item{range}{Numeric vector, indicating the lower and upper bound of the search range. If \code{range} is to large with regard to \code{trast}, the algorithm will fail.}

\item{trast}{A template \code{RasterLayer}.}

\item{num.of.parts}{Numeric numeric scalar, indicating the number of contiguous  polygons desired. This will usually be one.}

\item{levels}{The home range level.}

\item{tol}{Numeric scalar, indicating which difference of to stop.}

\item{max.it}{Numeric scalar, indicating the maximum number of acceptable iterations.}
}
\value{
\code{list} with the calculated bandwidth, exit status and the number of iteration.
}
\description{
Use two dimensional reference bandwidth to select a bandwidth for kernel density estimation.
Find the smallest value for bandwidth (h) that results in n polygons
(usually n=1) contiguous polygons at a given level.
}
\details{
This implementation uses a bisection algorithm to the find the smallest value
value for the kernel bandwidth within \code{range} that produces an home-range
isopleth at \code{level} consisting of \code{n} polygons. Note, no difference is
is made between the two dimensions.
}
\references{
Kie, John G. "A rule-based ad hoc method for selecting a bandwidth in kernel home-range analyses." Animal Biotelemetry 1.1 (2013): 1-12.
}
