% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ability_ai.R
\name{vis_diff_ai}
\alias{vis_diff_ai}
\title{Visualize Risk (AI v. Human; internal)}
\usage{
vis_diff_ai(
  df,
  label.subgroup1 = "Subgroup 1",
  label.subgroup2 = "Subgroup 2",
  x.order = NULL,
  zero.line = TRUE,
  arrows = TRUE,
  y.min = -Inf,
  p.title = NULL,
  p.lb = -1,
  p.ub = 1,
  y.lab = "PSA versus Human",
  p.label = c("PSA worse", "PSA better")
)
}
\arguments{
\item{df}{A data frame generated by \code{compute_stats_aipw} and reshaped.}

\item{label.subgroup1}{A label for subgroup1 (character).}

\item{label.subgroup2}{A label for subgroup2 (character).}

\item{x.order}{An order for the x-axis (character vector). Default NULL.}

\item{zero.line}{A logical indicating whether to include a zero line. Default TRUE.}

\item{arrows}{A logical indicating whether to include arrows. Default TRUE.}

\item{y.min}{A lower bound for the y-axis (numeric). Default -Inf.}

\item{p.title}{A title for the plot (character). Default NULL.}

\item{p.lb}{A lower bound for the y-axis (numeric). Default -0.2.}

\item{p.ub}{An upper bound for the y-axis (numeric). Default 0.2.}

\item{y.lab}{A label for the y-axis (character). Default "PSA versus Human".}

\item{p.label}{A vector of two labels for the annotations (character). Default c("PSA harms", "PSA helps").}
}
\value{
A ggplot object.
}
\description{
Internal function to visualize the difference in risk between AI and human decision makers.
}
\keyword{internal}
