% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ability_human_override.R
\name{plot_diff_subgroup}
\alias{plot_diff_subgroup}
\title{Visualize Difference in Risk (Human+AI v. Human) for a Subgroup Defined by AI Recommendation}
\usage{
plot_diff_subgroup(
  Y,
  D,
  Z,
  A,
  a = 1,
  V = NULL,
  l01 = l01,
  nuis_funcs = NULL,
  true.pscore = NULL,
  subgroup1,
  subgroup2,
  label.subgroup1 = "Subgroup 1",
  label.subgroup2 = "Subgroup 2",
  x.order = NULL,
  p.title = NULL,
  p.lb = -1,
  p.ub = 1,
  y.lab = "Impact of PSA",
  p.label = c("Human correct", "PSA correct"),
  label = "TNP - FNP",
  metrics = c("Misclassification Rate", "False Negative Proportion",
    "False Positive Proportion")
)
}
\arguments{
\item{Y}{An observed outcome (binary: numeric vector of 0 or 1).}

\item{D}{An observed decision (binary: numeric vector of 0 or 1).}

\item{Z}{A treatment indicator (binary: numeric vector of 0 or 1).}

\item{A}{An AI recommendation (binary: numeric vector of 0 or 1).}

\item{a}{A specific AI recommendation value to create the subset (numeric: 0 or 1).}

\item{V}{A matrix of pretreatment covariates (numeric matrix). Optional.}

\item{l01}{Ratio of the loss between false positives and false negatives. Default 1.}

\item{nuis_funcs}{output from \code{\link{compute_nuisance_functions}}. If NULL, the function will compute the nuisance functions using the provided data. Note that \code{V} must be provided if \code{nuis_funcs} is NULL.}

\item{true.pscore}{A vector of true propensity scores (numeric), if available. Optional.}

\item{subgroup1}{A pretreatment covariate used for subgroup analysis (vector).}

\item{subgroup2}{A pretreatment covariate used for subgroup analysis (vector).}

\item{label.subgroup1}{A label for subgroup1 (character). Default "Subgroup 1".}

\item{label.subgroup2}{A label for subgroup2 (character). Default "Subgroup 2".}

\item{x.order}{An order for the x-axis (character vector). Default NULL.}

\item{p.title}{A title for the plot (character). Default NULL.}

\item{p.lb}{A lower bound for the y-axis (numeric). Default -1.}

\item{p.ub}{An upper bound for the y-axis (numeric). Default 1.}

\item{y.lab}{A label for the y-axis (character). Default "Impact of PSA".}

\item{p.label}{A vector of two labels for the annotations (character). Default c("Human correct", "PSA correct").}

\item{label}{A label for the plot (character). Default "TNP - FNP".}

\item{metrics}{A vector of metrics to include in the plot (character). Default c("Misclassification Rate", "False Negative Proportion", "False Positive Proportion").}
}
\value{
A ggplot object.
}
\description{
Visualize the the difference in risk between human+AI and human decision makers using AIPW estimators, for a subgroup defined by AI recommendation.
Generate a plot based on the overall agreement and subgroup-specific agreement.
}
\examples{
plot_diff_subgroup(
  Y = NCAdata$Y,
  D = ifelse(NCAdata$D == 0, 0, 1),
  Z = NCAdata$Z,
  A = PSAdata$DMF,
  a = 1,
  l01 = 1,
  nuis_funcs = nuis_func,
  true.pscore = rep(0.5, nrow(NCAdata)),
  subgroup1 = ifelse(NCAdata$White == 1, "White", "Non-white"),
  subgroup2 = ifelse(NCAdata$Sex == 1, "Male", "Female"),
  label.subgroup1 = "Race",
  label.subgroup2 = "Gender",
  x.order = c("Overall", "Non-white", "White", "Female", "Male"),
  p.title = NULL, p.lb = -0.5, p.ub = 0.5,
  label = "TNP - FNP",
  metrics = c("True Negative Proportion (TNP)", "False Negative Proportion (FNP)", "TNP - FNP")
)

}
