% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ability_compute_bounds.R
\name{compute_bounds_aipw}
\alias{compute_bounds_aipw}
\title{Compute Risk (AI v. Human)}
\usage{
compute_bounds_aipw(
  Y,
  A,
  D,
  Z,
  X = NULL,
  nuis_funcs,
  nuis_funcs_ai,
  true.pscore = NULL,
  l01 = 1
)
}
\arguments{
\item{Y}{An observed outcome (binary: numeric vector of 0 or 1).}

\item{A}{An observed AI recommendation (binary: numeric vector of 0 or 1).}

\item{D}{An observed decision (binary: numeric vector of 0 or 1).}

\item{Z}{A treatment indicator (binary: numeric vector of 0 or 1).}

\item{X}{Pretreatment covariate used for subgroup analysis (vector). Must be the same length as Y, D, Z, and A if provided. Default is NULL.}

\item{nuis_funcs}{output from \code{\link{compute_nuisance_functions}}}

\item{nuis_funcs_ai}{output from \code{\link{compute_nuisance_functions_ai}}}

\item{true.pscore}{A vector of true propensity scores (numeric), if available. Optional.}

\item{l01}{Ratio of the loss between false positives and false negatives}
}
\value{
A tibble the following columns:
\itemize{
 \item \code{Z_focal}: The focal treatment indicator. `1` indicates the treatment group.
 \item \code{Z_compare}: The comparison treatment indicator. `0` indicates the control group.
 \item \code{X}: Pretreatment covariate (if provided).
 \item \code{fn_diff_lb}: The lower bound of difference in false negatives
 \item \code{fn_diff_ub}: The upper bound of difference in false negatives
 \item \code{fp_diff_lb}: The lower bound of difference in false positives
 \item \code{fp_diff_ub}: The upper bound of difference in false positives
 \item \code{loss_diff_lb}: The lower bound of difference in loss
 \item \code{loss_diff_ub}: The upper bound of difference in loss
 \item \code{fn_diff_lb_se}: The standard error of the difference in false negatives
 \item \code{fn_diff_ub_se}: The standard error of the difference in false negatives
 \item \code{fp_diff_lb_se}: The standard error of the difference in false positives
 \item \code{fp_diff_ub_se}: The standard error of the difference in false positives
 \item \code{loss_diff_lb_se}: The standard error of the difference in loss
 \item \code{loss_diff_ub_se}: The standard error of the difference in loss
 }
}
\description{
Compute the difference in risk between AI and human decision makers using AIPW estimators.
}
\examples{
compute_bounds_aipw(
  Y = NCAdata$Y,
  A = PSAdata$DMF,
  D = ifelse(NCAdata$D == 0, 0, 1),
  Z = NCAdata$Z,
  nuis_funcs = nuis_func,
  nuis_funcs_ai = nuis_func_ai,
  true.pscore = rep(0.5, nrow(NCAdata)),
  X = NULL,
  l01 = 1
)
}
