% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weight_outlier.R
\name{weight_outlier}
\alias{weight_outlier}
\title{Weighting method: Down weighting outliers}
\usage{
weight_outlier(expert_judgements)
}
\arguments{
\item{expert_judgements}{A dataframe in the form of \link{data_ratings}}
}
\value{
A tibble in the form of the input \code{expert_judgements} argument with additional columns
supplying the calculated weight for each row's observation.
}
\description{
This method down-weights outliers.
}
\details{
This function is used by \link{LinearWAgg} to calculate weights for the aggregation type
\code{"OutWAgg"}. Outliers are given less weight by using the squared difference between the
median of an individual's best estimates across all claims and their best estimate
for the claim being assessed:
\loadmathjax
\mjdeqn{d_{i,c} = \left(median\{{B_{i,c}}_{_{i=1,...,N}}\} - B_{i,c}\right)^2}{ascii}

Weights are given by 1 minus the proportion of the individual's squared difference
relative to the maximum squared difference for the claim across all individuals:

\mjdeqn{w\_out_{i} = 1 - \frac{d_{i,c}}{\max({d_c})})}{ascii}
}
