% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_score_evaluation.R
\name{confidence_score_evaluation}
\alias{confidence_score_evaluation}
\title{Confidence Score Evaluation}
\usage{
confidence_score_evaluation(confidence_scores, outcomes)
}
\arguments{
\item{confidence_scores}{A dataframe in the format output by the \verb{aggreCAT::} aggregation methods}

\item{outcomes}{A dataframe with two columns: \code{paper_id} (corresponding to the id's from the
confidence_scores), and \code{outcome} containing the known outcome of replication studies}
}
\value{
Evaluated dataframe with four columns: \code{method} (character variable describing the aggregation method),
\code{AUC} (Area Under the Curve (AUC) scores of ROC curves - see \code{?precrec::auc}), \code{Brier_Score} (see
\code{?DescTools::BrierScore}) and \code{Classification_Accuracy}(classification accuracy measured for pcc =
percent correctly classified; see \code{?MLmetrics::Accuracy}).
}
\description{
Evaluate the performance of the confidence scores generated by one or more aggregation
methods. Assumes probabilistic confidence scores for the metrics selected.
}
\examples{
\donttest{
confidence_score_evaluation(data_confidence_scores,
                            data_outcomes)
}

}
