% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hazard_2d_LMM.R
\name{get_hazard_2d_LMM}
\alias{get_hazard_2d_LMM}
\title{Get estimated (log-)hazard surface with 2 time scales}
\usage{
get_hazard_2d_LMM(
  fitted_model,
  plot_grid = NULL,
  where_slices = NULL,
  direction = c("u", "s", NULL),
  tmax = NULL
)
}
\arguments{
\item{fitted_model}{is an object of class \code{'haz2tsLMM'}
the output of the function \code{fit2ts()}.}

\item{plot_grid}{A list containing the parameters to build a new
finer grid of intervals over \code{u} and \code{s} for plotting. This must be of the
form: \code{plot_grid = list(c(umin, umax, du), c(smin, smax, ds))}, where
\code{umin}, \code{umax} and \code{smin}, \code{smax} are the minimum and maximum values
desired for the intervals over \code{u} and \code{s} respectively, and \code{du}, \code{ds} are
distances between intervals over \code{u} and \code{s} respectively. Specifying a new
denser grid is used to evaluate the B-spline bases used for estimation on
such grid and plot the estimated surfaces with a greater level of details.
If not specified, the plotting is done using the same B-splines bases as
for the estimation. The function will check if the parameters for the grid
provided by the user are compatible with those originally used to construct
the B-splines for estimating the model. If not, the grid will be adjusted
accordingly and a warning will be returned. While for objects of class 'haz2ts'
this is an optional input, we strongly recommend to provide the plotting
grid for object of class 'haz2tsLMM', given that evaluation of the B-splines
works a bit differently in LMMsolver.}

\item{where_slices}{A vector of values for the cutting points of the desired
slices of the surface. If \code{which_plot == "slices"}, please provide this
argument. Please also provide this argument in case \verb{which_plot = "survival}
or \verb{which_plot = "cumhaz} and \code{surv_slices = TRUE} or \code{cumhaz_slices = TRUE},
respectively.}

\item{direction}{If \code{which_plot == "slices"}, indicates the direction for
cutting the surface. If \code{u}, then the surface will be cut at the selected
values of \code{u} (indicated by \code{where_slices}), hence obtaining one-dimensional
curves over \code{s}. If \code{s}, then the surface will be cut at the selected values
of \code{s} (indicated by \code{where_slices}), hence obtaining one-dimensional curves
over \code{u}.}

\item{tmax}{The maximum value of \code{t} that should be plotted.}
}
\value{
A list with the following elements:
\itemize{
\item \code{new_plot_grid} A list of parameters that specify the new grid, of the form
list("intu", "umin", "umax", "du", "ints", "smin", "smax", "ds")
\item \code{hazard} A matrix containing the estimated hazard values.
\item \code{loghazard} A matrix containing the estimated log-hazard values.
\item \code{log10hazard}A matrix containing the estimated log10-hazard values.
\item \code{SE_hazard} A matrix containing the estimated SEs for the hazard.
\item \code{SE_loghazard} A matrix containing the estimated SEs for the log-hazard.
\item \code{SE_log10haz} A matrix containing the estimated SEs for the log10-hazard.
}
}
\description{
\code{get_hazard_2d_LMM()} takes as input an object of class \code{'haz2tsLMM'}
and it returns the estimated smooth log-hazard, the log10-hazard and the
hazard surface together with their standard errors.

It is possible to provide values that define a new grid for evaluation of the
estimated hazard.
If not specified, the hazard is evaluated on the same grid used for the
binning of the data, and therefore the estimation of the model.
The function will check if the parameters for the new grid
provided by the user are compatible with those originally used to construct
the B-splines for estimating the model. If not, the grid will be adjusted
accordingly and a warning will be returned.
}
\examples{
# Create some fake data - the bare minimum
id <- 1:20
u <- c(
  5.43, 3.25, 8.15, 5.53, 7.28, 6.61, 5.91, 4.94, 4.25, 3.86, 4.05, 6.86,
  4.94, 4.46, 2.14, 7.56, 5.55, 7.60, 6.46, 4.96
)
s <- c(
  0.44, 4.89, 0.92, 1.81, 2.02, 1.55, 3.16, 6.36, 0.66, 2.02, 1.22, 3.96,
  7.07, 2.91, 3.38, 2.36, 1.74, 0.06, 5.76, 3.00
)
ev <- c(1, 0, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1) #'

fakedata <- as.data.frame(cbind(id, u, s, ev))
fakedata2ts <- prepare_data(data = fakedata,
                            u = "u",
                            s_out = "s",
                            ev = "ev",
                            ds = .5)
# Fit a fake model - not optimal smoothing
fakemod <- fit2ts(fakedata2ts,
  optim_method = "LMMsolver"
)

# Get hazard
get_hazard_2d_LMM(fakemod)

# Use a finer grid of points
get_hazard_2d_LMM(fakemod,
                 plot_grid = list(c(umin = 3, umax = 8.5, du = .1),
                                  c(smin = 0, smax = 7.1, ds = .1)))

}
