% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TLSWsim.R
\name{TLSWsim}
\alias{TLSWsim}
\title{Simulate Trend Locally Stationary Wavelet Process}
\usage{
TLSWsim(
  trend,
  spec,
  filter.number = 4,
  family = "DaubExPhase",
  innov.func,
  ...
)
}
\arguments{
\item{trend}{Either:
\itemize{
\item{A numeric vector of length \eqn{n} giving the values of the deterministic
trend function,}
\item{A real-valued function of one argument defined on rescaled time \eqn{[0,1)}.}
}
When using a numeric vector for \code{trend}, if \eqn{n} is not a power of 2 then \code{spec} must be specified using
a numeric matrix of dimensions \eqn{\lfloor \log_2 (n) \rfloor \times n}.}

\item{spec}{Either:
\itemize{
\item{A \code{wavethresh} object of class wd which contains the spectrum for simulating
an LSW process,}
\item{A numeric matrix of dimensions \eqn{J \times n}, where the \eqn{j}-th row corresponds to the spectrum values at scale \eqn{j} and
\eqn{\lfloor \log_2 (n) \rfloor = J},}
\item{A list of length \eqn{J=\log_2(n)}, where the \eqn{j}-th element of the list is a function of one argument specifying the spectrum
function at scale \eqn{j} on rescaled time \eqn{[0,1)}.}
}
When using a numeric matrix for \code{spec}, if \eqn{n} is not a power of 2 then \code{trend}
must be specified using a numeric vector of length \eqn{n}.}

\item{filter.number}{The filter number for the wavelet used to simulate the LSW process (default 4)}

\item{family}{The family of the wavelet used to simulate the LSW process (default \code{DaubExPhase}).}

\item{innov.func}{A function with first argument \code{n} used for simulating the innovations. By default,
normal random innovations are sampled using the \code{rnorm} function.}

\item{...}{Optional arguments to be passed to the function  \code{innov.func} for
sampling the innovation process.}
}
\value{
A \eqn{n}-length vector containing a TLSW process simulated from the trend and spectral description given by the trend and
spec arguments.
}
\description{
Simulates a trend locally stationary wavelet process with a given trend function
and spectrum. Extends the \code{LSWsim} function from the \code{wavethresh} package.
}
\examples{

#---- simulate with numeric trend, and spec a wd object as in wavethresh-----

spec <- wavethresh::cns(1024)

spec <- wavethresh::putD(spec, level = 8, seq(from = 2, to = 8, length = 1024))

trend <- sin(pi * (seq(from = 0, to = 4, length = 1024)))

x <- TLSWsim(trend = trend, spec = spec)

plot.ts(x)

#---- simulate with numeric trend, and spec a matrix, with non-dyadic n-----

spec <- matrix(0, nrow = 9, ncol = 1000)

spec[1, ] <- seq(from = 1, to = 10, length = 1000)

trend <- sin(pi * (seq(from = 0, to = 4, length = 1000)))

x <- TLSWsim(trend = trend, spec = spec)

plot.ts(x)

#---- simulate with functional trend, and spec a list of functions-----

spec <- vector(mode = "list", length = 10)

spec[[1]] <- function(u) {
  1 + 9 * u
}

trend <- function(u) {
  sin(pi * u)
}

x <- TLSWsim(trend = trend, spec = spec)

plot.ts(x)

}
\seealso{
\code{\link[wavethresh]{LSWsim}}
}
