% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-aic-triangular.R
\name{util_triangular_aic}
\alias{util_triangular_aic}
\title{Calculate Akaike Information Criterion (AIC) for Triangular Distribution}
\usage{
util_triangular_aic(.x)
}
\arguments{
\item{.x}{A numeric vector containing the data to be fitted to a triangular
distribution.}
}
\value{
The AIC value calculated based on the fitted triangular distribution to the provided data.
}
\description{
This function estimates the parameters of a triangular distribution
(min, max, and mode) from the provided data and calculates the AIC value
based on the fitted distribution.
}
\details{
This function calculates the Akaike Information Criterion (AIC) for a
triangular distribution fitted to the provided data.

The function operates in several steps:
\enumerate{
\item \strong{Parameter Estimation}: The function extracts the minimum, maximum, and
mode values from the data via the \code{TidyDensity::util_triangular_param_estimate}
function. It returns these initial parameters as the starting point for
optimization.
\item \strong{Negative Log-Likelihood Calculation}: A custom function calculates the
negative log-likelihood using the \code{EnvStats::dtri} function to obtain density
values for each data point. The densities are logged manually to simulate the
behavior of a \code{log} parameter.
\item \strong{Parameter Validation}: During optimization, the function checks that the
constraints \verb{min <= mode <= max} are met, and returns an infinite loss if not.
\item \strong{Optimization}: The optimization process utilizes the "SANN"
(Simulated Annealing) method to minimize the negative log-likelihood and find
optimal parameter values.
\item \strong{AIC Calculation}: The Akaike Information Criterion (AIC) is calculated
using the optimized negative log-likelihood and the total number of parameters
(3).
}
}
\examples{
# Example: Calculate AIC for a sample dataset
set.seed(123)
data <- tidy_triangular(.min = 0, .max = 1, .mode = 1/2)$y
util_triangular_aic(data)

}
\seealso{
Other Utility: 
\code{\link{check_duplicate_rows}()},
\code{\link{convert_to_ts}()},
\code{\link{quantile_normalize}()},
\code{\link{tidy_mcmc_sampling}()},
\code{\link{util_beta_aic}()},
\code{\link{util_binomial_aic}()},
\code{\link{util_cauchy_aic}()},
\code{\link{util_chisq_aic}()},
\code{\link{util_exponential_aic}()},
\code{\link{util_f_aic}()},
\code{\link{util_gamma_aic}()},
\code{\link{util_generalized_beta_aic}()},
\code{\link{util_generalized_pareto_aic}()},
\code{\link{util_geometric_aic}()},
\code{\link{util_hypergeometric_aic}()},
\code{\link{util_inverse_burr_aic}()},
\code{\link{util_inverse_pareto_aic}()},
\code{\link{util_inverse_weibull_aic}()},
\code{\link{util_logistic_aic}()},
\code{\link{util_lognormal_aic}()},
\code{\link{util_negative_binomial_aic}()},
\code{\link{util_normal_aic}()},
\code{\link{util_paralogistic_aic}()},
\code{\link{util_pareto1_aic}()},
\code{\link{util_pareto_aic}()},
\code{\link{util_poisson_aic}()},
\code{\link{util_t_aic}()},
\code{\link{util_uniform_aic}()},
\code{\link{util_weibull_aic}()},
\code{\link{util_zero_truncated_binomial_aic}()},
\code{\link{util_zero_truncated_geometric_aic}()},
\code{\link{util_zero_truncated_negative_binomial_aic}()},
\code{\link{util_zero_truncated_poisson_aic}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
