depth <- function(src){
  sc <-  paste0('https://apiv2.nobitex.ir/v2/depth/',src)
  res <- fromJSON(paste(readLines(sc,warn=FALSE), collapse=""))
  
  ask<-do.call(rbind,res$ask)
  bid<-do.call(rbind,res$bid)
  
  bid<-bid[order(bid[,2]),]
  
  depth0<-cbind(ask,bid)
  depth0<-apply(depth0, 2, as.numeric)
  colnames(depth0)<-c("prc.ask","vol.ask","prc.bid","vol.bid")
  return(as.data.frame(depth0))
}