% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TGSTFunctions.R
\name{nonpar.fnr.fpr}
\alias{nonpar.fnr.fpr}
\title{Nonparametric FNR FPR of the rules}
\usage{
nonpar.fnr.fpr(Z, S, l, u)
}
\arguments{
\item{Z}{True disease status (No disease / treatment success coded as Z=0, diseased / treatment failure coded as Z=1).}

\item{S}{Risk score.}

\item{l}{Lower cutoff of tripartite rule.}

\item{u}{Upper cutoff of tripartite rule.}
}
\value{
Matrix with 2 columns. Each row is a set of nonparametric (FNR, FPR) on an associated tripartite rule.
}
\description{
This function gives you the nonparametric FNR and FPR associated with a given tripartite rule.
}
\examples{
d = Simdata
Z = d$Z # True Disease Status
S = d$S # Risk Score
phi = 0.1 #10\% of patients taking viral load test
rules = nonpar.rules( Z, S, phi)
nonpar.fnr.fpr(Z,S,rules[1,1],rules[1,2])
}
\keyword{nonparametric}
\keyword{rules}
