% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TGSTFunctions.R
\name{cal.AUC}
\alias{cal.AUC}
\title{Calculate AUC}
\usage{
cal.AUC(Z, S, l, u)
}
\arguments{
\item{Z}{True disease status (No disease / treatment success coded as Z=0, diseased / treatment failure coded as Z=1).}

\item{S}{Risk score.}

\item{l}{Lower cutoff of all possible tripartite rules.}

\item{u}{Upper cutoff of all possible tripartite rules.}
}
\value{
AUC.
}
\description{
This function gives you the AUC associated with the rules set.
}
\examples{
d = Simdata
Z = d$Z # True Disease Status
S = d$S # Risk Score
phi = 0.1 #10\% of patients taking viral load test
rules = nonpar.rules( Z, S, phi)
cal.AUC(Z,S,rules[,1],rules[,2])
}
\keyword{AUC}
