% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxDTdep.R
\name{coxDTdep}
\alias{coxDTdep}
\title{Fit Cox Proportional Hazards Regression Model Under Dependent Double Truncation}
\usage{
coxDTdep(
  formula,
  L,
  R,
  data,
  error = 1e-04,
  n.iter = 1000,
  n.boot = 100,
  CI.level = 0.95
)
}
\arguments{
\item{formula}{a formula object, with the response on the left of a ~ operator, and the terms on the right. The response must be a survival object as returned by the \code{Surv}. function. NOTE: \code{coxDTdep} does not handle censoring.}

\item{L}{vector of left truncation times. If only right truncation is present, set L = -infinity.}

\item{R}{vector right truncation times. If only left truncation is present, set R=infinity.}

\item{data}{mandatory data.frame matrix needed to interpret variables named in the \code{formula}}

\item{error}{tolerance for convergence, default is 1e-4.}

\item{n.iter}{maximun number of iterations for EM algorithm, default is 1000.}

\item{n.boot}{number of bootstraps for computing standard errors, default is 100.}

\item{CI.level}{a numeric value between 0.5 and 1 representing the confidence level for two-sided confidence intervals, default is 0.95}
}
\value{
Displays the estimate, standard error, lower and upper bounds of confidence interval, Wald test statistic and p-value for each regression coefficient
}
\description{
Fits a Cox proportional hazards regression model under dependent double truncation. That is, when the survival time is subject to left truncation and/or right truncation and the survival times are dependent on at least one of the truncation times.
}
\details{
Fits a Cox proportional hazards model in the presence of left, right, or double truncation when the survival times are
dependent on at least one of the truncation times. An EM algorithm is employed to obtain point estimates for the regression coefficients.
The standard errors are calculated using the bootstrap method. This method assumes no censoring is present in the data.
Note: If only left truncation is present, set R=infinity. If only right truncation is present, set L = -infinity.
}
\examples{
###### Example: AIDS data set #####
\dontrun{coxDTdep(Surv(Induction.time)~Adult, L=AIDS$L.time, R=AIDS$R.time, data=AIDS, n.boot=2)}

# WARNING: To save computation time, number of bootstrap resamples for standard error set to 2.
# Note: The minimum recommendation is 100, which is the default setting.
}
\references{
Rennert L and Xie SX (2022). Cox regression model under dependent truncation. Biometrics. 78(2), 460-473.  https://doi.org/10.1111/biom.13451
}
