% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_grid.R
\name{grid_projection}
\alias{grid_projection}
\title{grid_projection}
\usage{
grid_projection(indicator_array, index_set)
}
\arguments{
\item{indicator_array}{An indicator array generated using the \code{confidence_grid} function.}

\item{index_set}{A vector containing the indices representing the dimensions to keep.}
}
\value{
A two-dimensional indicator array ready for visualization (\code{indicator_array} projected onto the subspace specified by \code{index_set}).
}
\description{
Projects the multidimensional indicator array generated by confidence_grid down to 2d for visualization
}
\examples{
### simple projection
ind_arr <- array(c(1, 0, 0, 0, 0, 1, 0, 1), dim = rep(2, 3))
print(ind_arr)
# project this indicator array onto a 2d subspace by first and second dimension
ind_arr_12 <- grid_projection(ind_arr, c(1,2))
print(ind_arr_12)
ind_arr_13 <- grid_projection(ind_arr, c(1,3))
print(ind_arr_13)
ind_arr_23 <- grid_projection(ind_arr, c(2,3))
print(ind_arr_23)
}
