% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singularize.R
\name{singularize}
\alias{singularize}
\title{Converts Words to their Singular Form}
\usage{
singularize(word, dictionary = TRUE)
}
\arguments{
\item{word}{Character.
A word}

\item{dictionary}{Boolean.
Should dictionary be used to verify word exists?
Default to \code{TRUE}}
}
\value{
Returns the word in singular form, unless a singular form
could not be found (then the original word is returned)
}
\description{
A function to change words to their singular form.
The rules for converting words to their singular forms
are based on the \strong{\emph{inverse}} of the grammar rules.
This function handles most special cases and some irregular cases (see examples)
but caution is necessary. If no singular form is identified, then the original
word is returned.
}
\examples{
# Handles any prototypical cases
# "dog"
singularize("dogs")

# "fox"
singularize("foxes")

# "wolf"
singularize("wolves")

# "octopus"
singularize("octopi")

# "taxon"
singularize("taxa")

# And most special cases:
# "wife"
singularize("wives")

# "fez"
singularize("fezzes")

# "roof"
singularize("roofs")

# "photo"
singularize("photos")

# And some irregular cases:
# "child"
singularize("children")

# "tooth"
singularize("teeth")

# "mouse"
singularize("mice")

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
