% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{summary.SeaSondeRCS}
\alias{summary.SeaSondeRCS}
\title{Summary Method for SeaSondeRCS Object}
\usage{
\method{summary}{SeaSondeRCS}(object, ...)
}
\arguments{
\item{object}{An object of class "SeaSondeRCS". This object should contain
at least a header list with metadata (such as station name, date/time, and cell counts)
and processing step information retrieved by the function
seasonder_getSeaSondeRCS_ProcessingSteps.}

\item{...}{Additional arguments. Currently not used, but supplied for compatibility with
generic summary methods.}
}
\value{
Invisibly returns the original SeaSondeRCS object.
}
\description{
Provides a concise summary of a SeaSondeRCS object by printing the processing steps
that have been applied to the data contained in the object.
}
\details{
This method first validates that the input object inherits from the "SeaSondeRCS" class.
It then retrieves the processing steps applied to the data using seasonder_getSeaSondeRCS_ProcessingSteps,
formats them into a readable string, and outputs the result via the cat function.
The function is designed for interactive use, and its output facilitates quick inspection of the object.
}
\examples{
obj <- list(header = list(nSiteCodeName = "Station1",
                            nDateTime = Sys.time(),
                            nDopplerCells = 256,
                            nRangeCells = 100))
class(obj) <- "SeaSondeRCS"
summary(obj)
}
