% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRAPM.R
\name{seasonder_validateCalibrationMatrixSeaSondeRAPM}
\alias{seasonder_validateCalibrationMatrixSeaSondeRAPM}
\title{Validate Calibration Matrix for a SeaSondeRAPM Object}
\usage{
seasonder_validateCalibrationMatrixSeaSondeRAPM(matrix)
}
\arguments{
\item{matrix}{A 3 x b complex matrix for calibration, where b is the number of bearings.}
}
\value{
TRUE if the matrix is valid. The function will stop execution and display an error message if the matrix is invalid.
}
\description{
This function validates the input calibration_matrix to ensure it meets the required specifications
for use in a SeaSondeRAPM object.
}
\details{
The function performs the following validation checks:
\enumerate{
\item Confirms that the input is a matrix.
\item Verifies that the matrix has exactly three rows.
\item Checks that the matrix contains only complex numbers.
}

If any of these validation steps fail, the function will log a fatal error and stop the execution using \code{rlang::abort}.
}
\examples{
valid <- seasonder_validateCalibrationMatrixSeaSondeRAPM(
  matrix(complex(real = 1, imaginary = 0), nrow = 3, ncol = 5)
)
}
\seealso{
\code{\link{seasonder_createSeaSondeRAPM}}
}
