% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRAPM.R
\name{seasonder_validateAttributesSeaSondeRAPM}
\alias{seasonder_validateAttributesSeaSondeRAPM}
\title{Validate Attributes for a SeaSondeRAPM Object}
\usage{
seasonder_validateAttributesSeaSondeRAPM(seasonde_apm_obj)
}
\arguments{
\item{seasonde_apm_obj}{A SeaSondeRAPM object whose attributes are to be validated.}
}
\value{
TRUE if all attributes are valid. The function will stop execution and display an error message if any of the attributes are invalid.
}
\description{
This function validates the attributes of a given SeaSondeRAPM object to ensure they meet the required specifications.
}
\details{
The function performs validation on the following attributes of the SeaSondeRAPM object:
\itemize{
\item quality_matrix
\item BEAR
\item Type
\item Creator
\item SiteName
\item SiteOrigin
\item FileName
\item CreateTimeStamp
\item ProcessingSteps
\item AmplitudeFactors
\item AntennaBearing
\item StationCode
\item BearingResolution
\item Smoothing
\item CommentLine
\item FileID
\item PhaseCorrections
}

It internally calls specific validation functions for each of these attributes. If any of the attributes are found to be invalid, the function will stop execution and display an error message.
}
\examples{
# Create a test SeaSondeRAPM object by reading sample file
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
obj <- seasonder_readSeaSondeRAPMFile(apm_file)
valid <- seasonder_validateAttributesSeaSondeRAPM(obj)
}
\seealso{
\code{\link{validate_SeaSondeRAPM_quality_matrix}},
\code{\link{validate_SeaSondeRAPM_BEAR}},
\code{\link{validate_SeaSondeRAPM_Type}},
\code{\link{validate_SeaSondeRAPM_Creator}},
\code{\link{validate_SeaSondeRAPM_SiteName}},
\code{\link{validate_SeaSondeRAPM_SiteOrigin}},
\code{\link{validate_SeaSondeRAPM_FileName}},
\code{\link{validate_SeaSondeRAPM_CreateTimeStamp}},
\code{\link{validate_SeaSondeRAPM_ProcessingSteps}},
\code{\link{validate_SeaSondeRAPM_AmplitudeFactors}},
\code{\link{validate_SeaSondeRAPM_AntennaBearing}},
\code{\link{validate_SeaSondeRAPM_StationCode}},
\code{\link{validate_SeaSondeRAPM_BearingResolution}},
\code{\link{validate_SeaSondeRAPM_Smoothing}},
\code{\link{validate_SeaSondeRAPM_CommentLine}},
\code{\link{validate_SeaSondeRAPM_FileID}},
\code{\link{validate_SeaSondeRAPM_PhaseCorrections}}
}
