% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_skip_cs_file}
\alias{seasonder_skip_cs_file}
\title{Skip SeaSonde Cross Spectra (CS) File Reading}
\usage{
seasonder_skip_cs_file(cond)
}
\arguments{
\item{cond}{The condition or error that occurred during the file reading process. This is used
to log a detailed error message indicating the reason for skipping the file.}
}
\value{
A list with header = NULL and data = NULL.
}
\description{
This function serves as a restart for \code{seasonder_readSeaSondeCSFile}. When invoked, it provides a
mechanism to gracefully handle file reading errors by logging an error message and skipping the current file processing.
}
\details{
This function is meant to be used within a custom condition handler. When a problematic condition
arises during the processing of a SeaSonde CS file, you can call \code{seasonder_skip_cs_file(cond)} to
trigger this restart, which allows for a graceful degradation by logging an error message and returning a specified value.

The effect of invoking this restart is twofold:
\enumerate{
\item An error message detailing the reason for skipping the file is logged.
\item The calling function (\code{seasonder_readSeaSondeCSFile}) will immediately return a list with \code{header = NULL} and \code{data = NULL}.
}
}
\examples{
# Example: Skip file reading using a withRestarts handler to return NULL header and data
result <- withRestarts(
  seasonder_skip_cs_file(simpleError("test error")),
  seasonder_skip_cs_file = function(cond) list(header = NULL, data = NULL)
)
print(result)
}
