% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_setSeaSondeRCS_ProcessingSteps}
\alias{seasonder_setSeaSondeRCS_ProcessingSteps}
\title{Setter for ProcessingSteps}
\usage{
seasonder_setSeaSondeRCS_ProcessingSteps(
  seasonder_cs_object,
  processing_steps,
  append = TRUE
)
}
\arguments{
\item{seasonder_cs_object}{SeaSondeRCS object}

\item{processing_steps}{new value}

\item{append}{append the new step or replace previous steps? Default: TRUE}
}
\value{
A SeaSondeRCS object with updated ProcessingSteps.
}
\description{
Setter for ProcessingSteps
}
\examples{
# Create a valid SeaSondeRCS object for examples
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
# Define and append new processing steps
new_steps <- "Example processing step"
cs_obj <- seasonder_setSeaSondeRCS_ProcessingSteps(cs_obj, new_steps)
print(seasonder_getSeaSondeRCS_ProcessingSteps(cs_obj))
}
