% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCSSY.R
\name{seasonder_read_reduced_encoded_data}
\alias{seasonder_read_reduced_encoded_data}
\title{Read Reduced Encoded Data from a Binary Connection}
\usage{
seasonder_read_reduced_encoded_data(connection, key, endian = "big")
}
\arguments{
\item{connection}{A binary connection from which the encoded data is read.}

\item{key}{A list containing a field \code{size} that indicates how many bytes of data to process.}

\item{endian}{A character string specifying the byte order; either \code{"big"} or \code{"little"}. The default is \code{"big"}.}
}
\value{
An integer vector containing the decoded numbers.
}
\description{
This function reads an array of numbers from a binary connection using a custom command-based protocol.
A block of data is processed according to its size specified in \code{key$size}. Within the block, the first byte read
is a command byte that determines how the subsequent bytes are interpreted. The function updates a running "tracking
value" based on the commands encountered and returns a vector of decoded numbers. The supported commands are:
}
\details{
\describe{
\item{0x9C}{Read 4 bytes as an unsigned 32-bit integer.}
\item{0x94}{Read one count byte, then (count+1) unsigned 32-bit integers.}
\item{0xAC}{Read 3 bytes as a 24-bit signed integer; add its value to the current tracking value.}
\item{0xA4}{Read one count byte, then (count+1) 24-bit signed integers; sequentially add each to the tracking value.}
\item{0x89}{Read 1 byte as a signed 8-bit integer; add it to the tracking value.}
\item{0x8A}{Read 2 bytes as a signed 16-bit integer; add it to the tracking value.}
\item{0x82}{Read one count byte, then (count+1) signed 16-bit integers; sequentially add each to the tracking value.}
\item{0x81}{Read one count byte, then (count+1) signed 8-bit integers; sequentially add each to the tracking value.}
}

A 24-bit signed integer is computed by reading 3 bytes and then adjusting the value by subtracting 16777216 if the
computed value is greater than or equal to 8388608 to account for the two's complement representation.
}
