% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_readSeaSondeCSFile}
\alias{seasonder_readSeaSondeCSFile}
\title{Read SeaSonde Cross Spectra (CS) File}
\usage{
seasonder_readSeaSondeCSFile(filepath, specs_path, endian = "big")
}
\arguments{
\item{filepath}{A character string specifying the path to the SeaSonde CS file.}

\item{specs_path}{A character string specifying the path to the YAML specifications for the CS file.}

\item{endian}{Character string indicating the byte order. Options are "big" (default) or "little".}
}
\value{
A list containing two components:
\itemize{
\item \code{header}: A list containing the processed header information of the CS file.
\item \code{data}: A list containing the processed data of the CS file. The structure
of this list depends on the content of the CS file and can contain components such as
\verb{SSA*}, \code{CSxy}, and \code{QC}.
}
}
\description{
This function reads and processes a SeaSonde CS file, extracting both its header and data.
}
\details{
The function starts by establishing a connection to the CS file specified by \code{filepath}.
It then reads the necessary metadata and header specifications from the \code{specs_path}.
Based on the CS file version determined from its header, it applies specific adjustments
to the header data. After processing the header, the function validates the CS file data
using \code{\link{seasonder_validateCSFileData}} and then reads the data itself via
\code{\link{seasonder_readSeaSondeCSFileData}}.
}
\section{Condition Management}{

This function utilizes the \code{rlang} package to manage conditions and provide detailed and structured condition messages:

\strong{Condition Classes}:
\itemize{
\item \code{seasonder_read_cs_file_error}: An error class that indicates a general problem when attempting to read the SeaSonde CS file.
\item \code{seasonder_cs_file_skipped}: Condition indicating that the processing of a CS file was skipped due to an error.
}

\strong{Condition Cases}:
\itemize{
\item Failure to open a connection to the file.
\item Unsupported version found in the specs file.
\item Any other error that can arise from dependent functions such as \code{seasonder_readSeaSondeCSFileHeader} and \code{seasonder_readSeaSondeCSFileData}.
}

\strong{Restart Options}:
This function provides a structured mechanism to recover from errors during its execution using the \code{rlang::withRestarts} function. The following restart option is available:

\describe{
\item{\code{seasonder_skip_cs_file(cond)}}{This allows for the graceful handling of file reading errors. If this restart is invoked, the function will log an error message indicating that the processing of a specific CS file was skipped and will return a list with \code{header = NULL} and \code{data = NULL}. The restart takes one argument: \code{cond} (the condition or error that occurred).
\itemize{
\item \strong{Usage}: In a custom condition handler, you can call \code{seasonder_skip_cs_file(cond)} to trigger this restart and skip the processing of the current CS file.
\item \strong{Effect}: If invoked, the function logs an error message detailing the reason for skipping the file and then returns a list with both the header and data set to NULL.
}}
}
}

\examples{
spec_file <- seasonder_defaultSpecsFilePath("CS")
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
cs <- seasonder_readSeaSondeCSFile(cs_file, spec_file, endian = "big")
str(cs)
}
\references{
Cross Spectra File Format Version 6. CODAR. 2016
}
\seealso{
\code{\link{seasonder_skip_cs_file}},
\code{\link{seasonder_validateCSFileData}},
\code{\link{seasonder_readSeaSondeCSFileHeader}},
\code{\link{seasonder_readSeaSondeCSFileData}},
\code{\link{seasonder_readYAMLSpecs}}
}
