% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCSSW.R
\name{seasonder_readCSSWBodyRangeCell}
\alias{seasonder_readCSSWBodyRangeCell}
\title{Read a Body Range Cell and Apply Scaling if Required}
\usage{
seasonder_readCSSWBodyRangeCell(
  connection,
  specs,
  dbRef,
  endian = "big",
  specs_key_size = NULL
)
}
\arguments{
\item{connection}{A binary connection from which keys and data are read.}

\item{specs}{A list defining the expected keys and their formats.}

\item{dbRef}{A numeric value providing the dB reference used in scaling.}

\item{endian}{A string specifying the byte order ("big" or "little"). Defaults to "big".}

\item{specs_key_size}{Optional specification for the key size block.}
}
\value{
A list with elements named after the keys read. For reduced data blocks, each element contains either
the raw decoded data or the scaled voltage values if a 'scal' block had been applied.
}
\description{
This function processes a block of keys from a binary connection according to a provided specification
('specs'). Each key is interpreted by reading it with \code{seasonder_readSeaSondeCSFileBlock} and processing
it based on its key name. The key processing follows these rules:
}
\details{
\itemize{
\item \strong{Scaling Block ('scal')}: Reads scaling parameters (fmax, fmin, fscale, dbRef) using
\code{seasonder_readCSSWFields} and stores them for later use.
\item \strong{Reduced Data Blocks (e.g., 'cs1a', 'cs2a', 'cs3a', 'c13m', 'c13a', etc.)}:
Reads the block using \code{seasonder_read_reduced_encoded_data}. If scaling parameters were set by a
preceding 'scal' block, the raw data is converted to voltage values using \code{seasonder_SeaSondeRCSSWApplyScaling};
otherwise, the raw data is returned.
\item \strong{Other Keys (e.g., 'csgn' and 'asgn')}: These keys invoke their specialized read functions for processing.
}

The function continues reading keys until it detects the 'END ' marker or a repeated 'indx' key, which signals
the end of the block.
}
