% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_limitFORCurrentRange}
\alias{seasonder_limitFORCurrentRange}
\title{Limit First Order Region (FOR) Based on Maximum Radial Velocity}
\usage{
seasonder_limitFORCurrentRange(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing spectral data and FOR parameters.}
}
\value{
The updated \code{SeaSondeRCS} object with the FOR bins filtered based on maximum velocity.
}
\description{
This function removes Doppler bins from the detected First Order Region (FOR) if their
corresponding radial velocity exceeds a predefined maximum threshold.
}
\details{
\strong{Steps in Current Range Limiting:}
\enumerate{
\item \strong{Retrieve Maximum Velocity Threshold:}
\itemize{
\item Extracts the \code{currmax} parameter from \code{\link{seasonder_getFOR_parameters}}.
}
\item \strong{Obtain Current FOR Detection Results:}
\itemize{
\item Retrieves the existing FOR Doppler bin indices from \code{\link{seasonder_getSeaSondeRCS_FOR}}.
}
\item \strong{Compute Radial Velocities for Doppler Bins:}
\itemize{
\item Calls \code{\link{seasonder_getBinsRadialVelocity}} to convert Doppler bins into radial velocities.
}
\item \strong{Identify Bins Exceeding Maximum Velocity:}
\itemize{
\item Finds the Doppler bins where the absolute radial velocity is greater than or equal to \code{currmax}.
}
\item \strong{Filter Out Exceeding Bins:}
\itemize{
\item Uses \code{\link[dplyr]{setdiff}} to remove bins exceeding \code{currmax} from the FOR region.
}
\item \strong{Store Updated FOR Data in Object:}
\itemize{
\item Updates the \code{SeaSondeRCS} object with the filtered FOR results.
}
}

This function ensures that only Doppler bins corresponding to physically realistic
radial velocities are included in the first-order Bragg region.
}
\seealso{
\itemize{
\item \code{\link{seasonder_getBinsRadialVelocity}} for computing radial velocities.
\item \code{\link{seasonder_getSeaSondeRCS_FOR}} for retrieving FOR bin indices.
\item \code{\link{seasonder_setSeaSondeRCS_FOR}} for storing updated FOR data.
}
}
