% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_initMUSICData}
\alias{seasonder_initMUSICData}
\title{Initialize MUSIC Data for SeaSondeR}
\usage{
seasonder_initMUSICData(
  seasonder_cs_object,
  range_cells = NULL,
  doppler_bins = NULL,
  NULL_MUSIC = FALSE
)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeR cross-spectral object containing metadata about the radar system.}

\item{range_cells}{An optional vector specifying the range cells to include. Defaults to all range cells in the object.}

\item{doppler_bins}{An optional vector specifying the Doppler bins to include. Defaults to all Doppler bins in the object.}

\item{NULL_MUSIC}{Logical. If \code{TRUE}, initializes the MUSIC structure with a NULL placeholder
(see \code{\link{seasonder_NULLSeaSondeRCS_MUSIC}}). Defaults to \code{FALSE}.}
}
\value{
The updated SeaSondeR cross-spectral object with initialized MUSIC-related attributes.
}
\description{
This function initializes the MUSIC data structure for a SeaSondeR cross-spectral object, including
optional interpolation, parameter setup, and pre-computed placeholders for MUSIC analysis.
}
\details{
The function performs the following steps:
\enumerate{
\item Ensures the SeaSondeR object has valid interpolation and parameter settings for MUSIC analysis.
\item Initializes the MUSIC data structure. If \code{NULL_MUSIC} is \code{FALSE}, the structure is
populated with range cell and Doppler bin combinations.
\item Computes proportion of dual solutions for MUSIC using \code{\link{seasonder_MUSICComputePropDualSols}}.
\item Initializes interpolated data for cross-spectral analysis using \code{\link{seasonder_MUSICInitInterpolatedData}}.
}

The final object is ready for further MUSIC analysis steps, such as computing Direction of Arrival (DOA).
}
\examples{
# Minimal example for initializing MUSIC data (all range cells and Doppler bins)
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
music_obj <- seasonder_initMUSICData(cs_obj)

# Example: specific range cells and Doppler bins
music_obj2 <- seasonder_initMUSICData(
  cs_obj,
  range_cells = c(1, 2),
  doppler_bins = c(1, 2, 5, 10)
)
}
\seealso{
\code{\link{seasonder_NULLSeaSondeRCS_MUSIC}} for initializing a NULL structure.
\code{\link{seasonder_initSeaSondeRCS_MUSIC}} for range and Doppler-based initialization.
\code{\link{seasonder_MUSICInitInterpolatedData}} for interpolated data initialization.
}
