% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_getVersion.SeaSondeRCS}
\alias{seasonder_getVersion.SeaSondeRCS}
\title{Get the version value from a SeaSondeRCS object}
\usage{
\method{seasonder_getVersion}{SeaSondeRCS}(seasonder_obj)
}
\arguments{
\item{seasonder_obj}{A SeaSondeRCS object.}
}
\value{
The version value.
}
\description{
Get the version value from a SeaSondeRCS object
}
\examples{
# Get version from a SeaSondeRCS object
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
value <- seasonder_getVersion(cs_obj)
print(value)
}
