% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_getSeaSondeRCS_dataMatrix}
\alias{seasonder_getSeaSondeRCS_dataMatrix}
\title{Retrieve a Specific Data Matrix from a SeaSondeRCS Object}
\usage{
seasonder_getSeaSondeRCS_dataMatrix(seasonder_cs_object, matrix_name)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing the spectral data.}

\item{matrix_name}{A string specifying the name of the matrix to retrieve. Must be one of:
\itemize{
\item \code{"SSA1"}: Self-spectra for antenna 1.
\item \code{"SSA2"}: Self-spectra for antenna 2.
\item \code{"SSA3"}: Self-spectra for antenna 3.
\item \code{"CS12"}: Cross-spectra between antennas 1 and 2.
\item \code{"CS13"}: Cross-spectra between antennas 1 and 3.
\item \code{"CS23"}: Cross-spectra between antennas 2 and 3.
\item \code{"QC"}: Quality control matrix.
}}
}
\value{
A matrix containing the requested spectral data. If the matrix name is invalid, an error is thrown.
}
\description{
This function extracts a specific data matrix from a SeaSondeRCS object. The available matrices
correspond to self-spectra and cross-spectra components used in SeaSonde radar processing.
}
\details{
The function first verifies that the provided \code{matrix_name} is valid. If the name is not
in the list of accepted values, it logs an error and aborts execution using \code{\link{seasonder_logAndAbort}}.
Once validated, the function extracts the requested matrix from the \code{data} component of the
SeaSondeRCS object.
}
\seealso{
\code{\link{seasonder_getSeaSondeRCS_data}} for retrieving the complete data structure.
\code{\link{seasonder_logAndAbort}} for error handling.
}
