% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_getSeaSondeRCS_FOR_SS_Smoothed}
\alias{seasonder_getSeaSondeRCS_FOR_SS_Smoothed}
\title{Retrieve Smoothed Self-Spectra for First Order Region (FOR)}
\usage{
seasonder_getSeaSondeRCS_FOR_SS_Smoothed(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing smoothed self-spectra data.}
}
\value{
A matrix representing the smoothed self-spectra, or \code{NULL} if no smoothed data is stored.
}
\description{
This function retrieves the smoothed self-spectra (SS) matrix stored in the \code{FOR_data} attribute
of a \code{SeaSondeRCS} object. The smoothed self-spectra are used in First Order Region (FOR) processing
to refine the detection of the first-order boundaries.
}
\details{
The function extracts the matrix assigned by \code{\link{seasonder_setSeaSondeRCS_FOR_SS_Smoothed}}.
If no smoothed self-spectra are found, the function returns \code{NULL}.

The smoothed self-spectra are typically generated using \code{\link{seasonder_SmoothSS}} and applied
to the self-spectra of antenna 3. This smoothing aids in detecting the nulls that separate first- and
second-order regions.
}
\seealso{
\itemize{
\item \code{\link{seasonder_SmoothFORSS}} for applying smoothing and storing the result.
\item \code{\link{seasonder_setSeaSondeRCS_FOR_SS_Smoothed}} for setting smoothed self-spectra.
}
}
