% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_getCenterDopplerBin}
\alias{seasonder_getCenterDopplerBin}
\title{Retrieve Center Doppler Bin}
\usage{
seasonder_getCenterDopplerBin(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing metadata about Doppler bins.}
}
\value{
A numeric value representing the center Doppler bin.
}
\description{
This function calculates the center Doppler bin index for a SeaSondeRCS object.
It obtains the total number of Doppler cells from the object using
\code{seasonder_getnDopplerCells} and computes the center bin with
\code{seasonder_computeCenterDopplerBin}.
}
\details{
The center Doppler bin is computed by retrieving the total number of Doppler cells
(via \code{seasonder_getnDopplerCells}) and then processing that value with
\code{seasonder_computeCenterDopplerBin}. Note that while CODAR data files might use
zero-based indexing, R uses one-based indexing.
}
