% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_SwapDopplerUnits}
\alias{seasonder_SwapDopplerUnits}
\title{Convert Between Different Doppler Frequency Units}
\usage{
seasonder_SwapDopplerUnits(seasonder_cs_object, values, in_units, out_units)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeR} cross-spectral object containing Doppler bin metadata.}

\item{values}{A numeric vector specifying the Doppler values to be converted.}

\item{in_units}{A character string specifying the current unit of \code{values}. Must be one of:
\itemize{
\item \code{"normalized doppler frequency"}: Values are normalized by the Bragg frequency.
\item \code{"bins"}: Values represent Doppler bin indices.
\item \code{"doppler frequency"}: Values are in Hz.
}}

\item{out_units}{A character string specifying the target unit for conversion. Must be one of the same three options as \code{in_units}.}
}
\value{
A numeric vector with the converted Doppler values in the specified output unit.
}
\description{
This function converts Doppler-related values between different units, including normalized Doppler frequency, Doppler bins, and absolute Doppler frequency (Hz), within a \code{SeaSondeR} object.
}
\details{
The function first validates that the input and output units are among the allowed options.
If \code{in_units} and \code{out_units} are the same, the function returns the original values without modification.

The unit conversions follow this logic:
\enumerate{
\item If converting from \code{"normalized doppler frequency"}:
\itemize{
\item To \code{"bins"}: Uses \code{\link{seasonder_NormalizedDopplerFreq2Bins}}.
\item To \code{"doppler frequency"}: Uses \code{\link{seasonder_NormalizedDopplerFreq2DopplerFreq}}.
}
\item If converting from \code{"bins"}:
\itemize{
\item To \code{"normalized doppler frequency"}: Uses \code{\link{seasonder_Bins2NormalizedDopplerFreq}}.
\item To \code{"doppler frequency"}: Uses \code{\link{seasonder_Bins2DopplerFreq}}.
}
\item If converting from \code{"doppler frequency"}:
\itemize{
\item To \code{"bins"}: Uses \code{\link{seasonder_DopplerFreq2Bins}}.
\item To \code{"normalized doppler frequency"}: Uses \code{\link{seasonder_DopplerFreq2NormalizedDopplerFreq}}.
}
}

Overall, the functions used for Doppler units conversion mimic the implementation of Doppler units displayed in  SpectraPlotterMap 12 in Radial Suite R8
}
\references{
COS. SeaSonde Radial Suite Release 8; CODAR Ocean Sensors (COS): Mountain View, CA, USA, 2016.
}
\seealso{
\code{\link{seasonder_NormalizedDopplerFreq2Bins}}, \code{\link{seasonder_Bins2NormalizedDopplerFreq}}, \code{\link{seasonder_DopplerFreq2Bins}}, and related functions for unit-specific conversions.
}
