% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_NormalizedDopplerFreq2Bins}
\alias{seasonder_NormalizedDopplerFreq2Bins}
\title{Convert Normalized Doppler Frequencies to Doppler Bins}
\usage{
seasonder_NormalizedDopplerFreq2Bins(seasonder_cs_object, doppler_values)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeR} cross-spectral object containing metadata about the Doppler bins.}

\item{doppler_values}{A numeric vector specifying the normalized Doppler frequencies to be converted into bin indices.}
}
\value{
An integer vector indicating the Doppler bin indices corresponding to the input normalized Doppler frequencies. Values that fall outside the valid bin range are assigned \code{NA}.
}
\description{
This function converts a set of normalized Doppler frequencies into their corresponding Doppler bin indices within a \code{SeaSondeR} object.
}
\details{
This function first retrieves the list of normalized Doppler frequencies from the given \code{SeaSondeR} object using \code{\link{seasonder_getDopplerBinsFrequency}}.
The bin boundaries are computed using the first-order difference of these frequencies.

The function then applies \code{\link{findInterval}} to determine the corresponding bin index for each input Doppler frequency. The search process is affected by the following options:
\itemize{
\item \code{rightmost.closed = TRUE}: The last bin interval is closed on the right, ensuring that the maximum normalized frequency is included in the last bin.
\item \code{all.inside = FALSE}: Values that fall outside the range of the computed boundaries are assigned values below 1 or above the maximum bin index.
\item \code{left.open = TRUE}: The left interval is open, meaning that values exactly equal to a boundary are assigned to the higher bin.
}

After \code{findInterval} determines the bin indices, values that are out of range (\code{bins < 1} or \code{bins > nDoppler}) are set to \code{NA}.
}
\seealso{
\code{\link{seasonder_Bins2NormalizedDopplerFreq}} for the inverse operation.
}
