% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_MUSICInitEigenDecomp}
\alias{seasonder_MUSICInitEigenDecomp}
\title{Initialize Eigenvalue Decomposition Structure for MUSIC Algorithm}
\usage{
seasonder_MUSICInitEigenDecomp()
}
\value{
A list with two elements:
\itemize{
\item \code{values}: Eigenvalues as a complex vector.
\item \code{vectors}: Eigenvectors as a complex matrix.
}
}
\description{
This function initializes the data structure for storing the eigenvalue decomposition
results used in the MUSIC algorithm.
}
\details{
The function returns a list with the following components:
\itemize{
\item \code{values}: A vector of length 3, initialized with \code{NA_complex_}, to hold the eigenvalues.
\item \code{vectors}: A 3 x 3 matrix, initialized with \code{NA_complex_}, to hold the eigenvectors.
}

This structure is designed to support three-channel antenna configurations typical in SeaSondeR applications.
}
\seealso{
\code{\link{seasonder_MUSICInitCov}} for initializing covariance matrices.
}
