% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalSVG_Seurat.R
\name{CalSVG_Seurat}
\alias{CalSVG_Seurat}
\title{Seurat-style SVG Detection Methods}
\usage{
CalSVG_Seurat(
  expr_matrix,
  spatial_coords,
  weight_scheme = c("inverse_squared", "inverse", "gaussian"),
  bandwidth = NULL,
  adjust_method = "BH",
  n_threads = 1L,
  verbose = TRUE
)
}
\arguments{
\item{expr_matrix}{Numeric matrix of gene expression values.
\itemize{
  \item Rows: genes
  \item Columns: spatial locations (spots/cells)
  \item Values: scaled/normalized expression (Seurat typically uses scale.data)
}}

\item{spatial_coords}{Numeric matrix of spatial coordinates.
\itemize{
  \item Rows: spatial locations (must match columns of expr_matrix)
  \item Columns: x, y coordinates
}}

\item{weight_scheme}{Character string specifying the distance-based weighting.
\itemize{
  \item \code{"inverse_squared"} (default): w_ij = 1 / d_ij^2
    (Seurat default, emphasizes local neighbors)
  \item \code{"inverse"}: w_ij = 1 / d_ij
    (less emphasis on close neighbors)
  \item \code{"gaussian"}: w_ij = exp(-d_ij^2 / (2 * bandwidth^2))
    (controlled by bandwidth parameter)
}}

\item{bandwidth}{Numeric. Bandwidth for Gaussian weighting.
Default is NULL (auto-computed as median pairwise distance).
Only used when \code{weight_scheme = "gaussian"}.}

\item{adjust_method}{Character string for p-value adjustment.
Default is "BH" (Benjamini-Hochberg).}

\item{n_threads}{Integer. Number of parallel threads. Default is 1.}

\item{verbose}{Logical. Print progress messages. Default is TRUE.}
}
\value{
A data.frame with SVG detection results. Columns:
  \itemize{
    \item \code{gene}: Gene identifier
    \item \code{observed}: Observed Moran's I statistic
    \item \code{expected}: Expected Moran's I under null
    \item \code{sd}: Standard deviation under null
    \item \code{p.value}: Raw p-value
    \item \code{p.adj}: Adjusted p-value
    \item \code{rank}: Rank by p-value (ascending)
  }
}
\description{
Detect spatially variable genes using methods implemented in Seurat,
including Moran's I with inverse distance weights and Mark Variogram.

Identifies spatially variable genes using Moran's I statistic with
inverse distance squared weighting, as implemented in Seurat's
\code{FindSpatiallyVariableFeatures} function.
}
\details{
\strong{Method Overview:}

This function replicates Seurat's \code{FindSpatiallyVariableFeatures}
with \code{selection.method = "moransi"}. The key difference from other
Moran's I implementations is the weighting scheme:

\deqn{w_{ij} = \frac{1}{d_{ij}^2}}

where d_ij is the Euclidean distance between locations i and j.

\strong{Interpretation:}
\itemize{
  \item Uses continuous distance-based weights (not binary network)
  \item Emphasizes local spatial relationships
  \item Higher weights for closer neighbors
}

\strong{Comparison with MERINGUE:}
\itemize{
  \item MERINGUE: Binary adjacency (neighbors = 1, others = 0)
  \item Seurat: Continuous weights (1/distance^2)
  \item Seurat method is more sensitive to local patterns
}
}
\examples{
# Load example data
data(example_svg_data)
expr <- example_svg_data$logcounts[1:20, ]
coords <- example_svg_data$spatial_coords

\donttest{
# Basic usage
results <- CalSVG_Seurat(expr, coords, verbose = FALSE)
head(results)
}

}
\references{
Hao, Y. et al. (2021) Integrated analysis of multimodal single-cell data.
Cell.

Stuart, T. et al. (2019) Comprehensive Integration of Single-Cell Data.
Cell.
}
\seealso{
\code{\link{CalSVG}}, \code{\link{CalSVG_MERINGUE}}
}
