#' Compute Frank Copula Parameter from Kendall's Tau
#'
#' Computes the Frank copula dependence parameter based on Kendall's tau.
#'
#' @param tau Numeric, Kendall's tau correlation coefficient.
#' @return Numeric, estimated Frank copula parameter.
#' @importFrom copula frankCopula tau
#' @export
#'
frank.theta <- function(tau){
  theta.grid <- seq(-10, 10, by = 0.001)
  theta.grid <- theta.grid[!theta.grid == 0]
  theta.frank <- rep(NA, length(theta.grid))
  for (i in 1:length(theta.frank)){
    theta.frank[i] <- copula::tau(copula::frankCopula(theta.grid[i])) - tau
  }
  theta_frank <- theta.grid[which.min(abs(theta.frank))]
  return(theta_frank)
}
