% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_validation.R
\name{cross_validation}
\alias{cross_validation}
\title{Assign Cross-Validation Folds for Labelled and Unlabelled Data}
\usage{
cross_validation(N, nfold, A, Y)
}
\arguments{
\item{N}{Integer. Total number of observations in the dataset.}

\item{nfold}{Integer. Number of folds to assign for cross-validation.}

\item{A}{Numeric vector. Treatment assignment indicator (may contain \code{NA} for unlabelled samples).}

\item{Y}{Numeric vector. Outcome variable (may contain \code{NA} for unlabelled samples).}
}
\value{
A list containing:
\describe{
\item{R}{Binary vector of length \code{N}, where 1 indicates labelled observations (non-missing \code{A} and \code{Y}),
and 0 indicates unlabelled observations.}
\item{foldid}{Integer vector of length \code{N}. Fold assignments (from 1 to \code{nfold}) for use in cross-validation.}
}
}
\description{
Creates fold assignments for both labelled and unlabelled data using stratified random sampling,
ensuring an approximately equal number of samples per fold within each group.
}
\details{
The function first separates observations into labelled and unlabelled groups based on the
availability of both treatment (\code{A}) and outcome (\code{Y}). Within each group,
fold assignments are randomly assigned to ensure approximately balanced sample sizes
across folds. This setup supports semi-supervised learning workflows by maintaining
structure between labelled and unlabelled data during cross-fitting.
}
\examples{
set.seed(123)
N <- 100
A <- sample(c(0, 1, NA), size = N, replace = TRUE, prob = c(0.45, 0.45, 0.10))
Y <- sample(c(0, 1, NA), size = N, replace = TRUE, prob = c(0.45, 0.45, 0.10))

# Assign 5 folds for cross-fitting
result <- cross_validation(N = N, nfold = 5, A = A, Y = Y)

table(result$R)  # Check number of labelled vs unlabelled
table(result$foldid)  # Check how folds are distributed


}
