% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.sgp.cv}
\alias{predict.sgp.cv}
\title{Predictions based on a SGP models}
\usage{
\method{predict}{sgp.cv}(
  object,
  X,
  lambda = object$lambda.min,
  index = object$min,
  extract = c("link", "response", "class", "coefficients", "vars", "groups", "nvars",
    "ngroups", "norm"),
  ...
)
}
\arguments{
\item{object}{A object that was generated with sgp.cv.}

\item{X}{The design matrix for making predictions.}

\item{lambda}{The value of lambda at which predictions should be made.}

\item{index}{The index that indicates the lambda at which predictions should be made (alternative to specifying 'lambda').}

\item{extract}{A string indicating the type of information to return.}

\item{\dots}{Other parameters of underlying basic functions.}
}
\value{
Different objects depending on the sting indicated by 'extract'.
}
\description{
A function that extracts information from a cross-validated SGP object and performs predictions.
}
\examples{
n <- 100
p <- 12
nr <- 4
g <- paste0("Group ",ceiling(1:p / nr))
X <- matrix(rnorm(n * p), n, p)
b <- c(-3:3)
y_lin <- X[, 1:length(b)] \%*\% b + 5 * rnorm(n)
y_log <- rbinom(n, 1, exp(y_lin) / (1 + exp(y_lin)))

lin_fit <- sgp.cv(X, y_lin, g, type = "linear")
predict(lin_fit, X = X, extract = "link")

log_fit <- sgp.cv(X, y_log, g, type = "logit")
predict(log_fit, X = X, extract = "class")

}
