#' Generate Geometric Inverse-Temperature Ladder
#' Constructs a geometric sequence of temperatures (inverse temperatures)
#' for parallel-tempering MCMC.
#' @param N_chain  Number of parallel chains (N_chain > 1).
#' @param T_max    Highest temperature (coldest chain).  Default is 10.
#' @return A numeric vector of length N_chain containing the
#'         geometrically spaced temperatures.
#' @export
#' @examples
#' set.seed(1)
#' temps <- generate_temperature(N_chain = 8, T_max = 10)
#' print(temps)
generate_temperature <- function(N_chain, T_max = 10) {
  T_seq <- T_max^((0:(N_chain - 1)) / (N_chain - 1))  # geometric ladder
  return(T_seq)
}