% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyhedra-lib.R
\docType{class}
\name{Polyhedron}
\alias{Polyhedron}
\title{Polyhedron}
\description{
Polyhedron container class, which is accessible by the final users upon call
}
\author{
ken4rab
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{file.id}}{Polyhedron file.id}

\item{\code{state}}{Polyhedron state}

\item{\code{logger}}{class logger}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Polyhedron-new}{\code{Polyhedron$new()}}
\item \href{#method-Polyhedron-scrapeNetlib}{\code{Polyhedron$scrapeNetlib()}}
\item \href{#method-Polyhedron-scrapeDmccooey}{\code{Polyhedron$scrapeDmccooey()}}
\item \href{#method-Polyhedron-deserialize}{\code{Polyhedron$deserialize()}}
\item \href{#method-Polyhedron-getName}{\code{Polyhedron$getName()}}
\item \href{#method-Polyhedron-getState}{\code{Polyhedron$getState()}}
\item \href{#method-Polyhedron-getSolid}{\code{Polyhedron$getSolid()}}
\item \href{#method-Polyhedron-isChecked}{\code{Polyhedron$isChecked()}}
\item \href{#method-Polyhedron-getRGLModel}{\code{Polyhedron$getRGLModel()}}
\item \href{#method-Polyhedron-exportToXML}{\code{Polyhedron$exportToXML()}}
\item \href{#method-Polyhedron-getErrors}{\code{Polyhedron$getErrors()}}
\item \href{#method-Polyhedron-checkProperties}{\code{Polyhedron$checkProperties()}}
\item \href{#method-Polyhedron-clone}{\code{Polyhedron$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Polyhedron-new"></a>}}
\if{latex}{\out{\hypertarget{method-Polyhedron-new}{}}}
\subsection{Method \code{new()}}{
Create a polyhedronState object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Polyhedron$new(file.id, state = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file.id}}{the file id}

\item{\code{state}}{polyhedron state object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new  Polyhedron object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Polyhedron-scrapeNetlib"></a>}}
\if{latex}{\out{\hypertarget{method-Polyhedron-scrapeNetlib}{}}}
\subsection{Method \code{scrapeNetlib()}}{
scrape Netlib polyhedron definition
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Polyhedron$scrapeNetlib(netlib.p3.lines)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{netlib.p3.lines}}{vector with netlib definition lines}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new  PolyhedronStateDefined object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Polyhedron-scrapeDmccooey"></a>}}
\if{latex}{\out{\hypertarget{method-Polyhedron-scrapeDmccooey}{}}}
\subsection{Method \code{scrapeDmccooey()}}{
scrape Dmccooey polyhedron definition
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Polyhedron$scrapeDmccooey(polyhedra.dmccooey.lines)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{polyhedra.dmccooey.lines}}{vector with Dmccooey definition lines}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new  PolyhedronStateDefined object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Polyhedron-deserialize"></a>}}
\if{latex}{\out{\hypertarget{method-Polyhedron-deserialize}{}}}
\subsection{Method \code{deserialize()}}{
deserialize a polyhedron state definition
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Polyhedron$deserialize(serialized.polyhedron)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{serialized.polyhedron}}{a serialized version of a polyhedron state}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new  PolyhedronStateDefined object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Polyhedron-getName"></a>}}
\if{latex}{\out{\hypertarget{method-Polyhedron-getName}{}}}
\subsection{Method \code{getName()}}{
get Polyhedron name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Polyhedron$getName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
string with polyhedron name
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Polyhedron-getState"></a>}}
\if{latex}{\out{\hypertarget{method-Polyhedron-getState}{}}}
\subsection{Method \code{getState()}}{
Gets polyhedron state
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Polyhedron$getState()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A new  PolyhedronState object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Polyhedron-getSolid"></a>}}
\if{latex}{\out{\hypertarget{method-Polyhedron-getSolid}{}}}
\subsection{Method \code{getSolid()}}{
Gets a solid definition
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Polyhedron$getSolid()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of vertex vectors composing polyhedron faces.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Polyhedron-isChecked"></a>}}
\if{latex}{\out{\hypertarget{method-Polyhedron-isChecked}{}}}
\subsection{Method \code{isChecked()}}{
checks Edges consistency
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Polyhedron$isChecked()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A boolean value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Polyhedron-getRGLModel"></a>}}
\if{latex}{\out{\hypertarget{method-Polyhedron-getRGLModel}{}}}
\subsection{Method \code{getRGLModel()}}{
Return an 'rgl' model with an optional transformation described by transformation.matrix parameter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Polyhedron$getRGLModel(transformation.matrix = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{transformation.matrix}}{transformation matrix parameter}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An tmesh3d object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Polyhedron-exportToXML"></a>}}
\if{latex}{\out{\hypertarget{method-Polyhedron-exportToXML}{}}}
\subsection{Method \code{exportToXML()}}{
exports an XML definition of current polyhedron
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Polyhedron$exportToXML()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character object with the XML definition
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Polyhedron-getErrors"></a>}}
\if{latex}{\out{\hypertarget{method-Polyhedron-getErrors}{}}}
\subsection{Method \code{getErrors()}}{
returns the errors found when processing current polyhedron
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Polyhedron$getErrors()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a data.frame with polyhedron errors
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Polyhedron-checkProperties"></a>}}
\if{latex}{\out{\hypertarget{method-Polyhedron-checkProperties}{}}}
\subsection{Method \code{checkProperties()}}{
check properties of current polyhedron
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Polyhedron$checkProperties(expected.vertices, expected.faces)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{expected.vertices}}{expected vertices number}

\item{\code{expected.faces}}{expected faces number}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Unmodified polyhedron object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Polyhedron-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Polyhedron-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Polyhedron$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
