
#' Sum of errors within the cluster
#'
#'  We calculate the distance between the points that belong to a cluster and the cluster centroid. Then, we sum all the distances obtained. In this function the user can choose the distance that want to use to calculate the sum of  errors within the cluster.
#'
#' @param data Matrix with \code{dim(data)[1]} points of \code{dim(data)[2]} dimensions.
#' @param distance Function. This function designs how the distance is going to be calculated. It must have as input two vectors and as output the distance of these vectors.
#' @param FHW_output List. List with:
#'
#' \itemize{
#'   \item centers: the information of the centers updated.
#'   \item grouping: the information of the groups updated. List. Each component of the list contains a vector with the points that belong to that group. More specifically, the list component i has a vector with the numbers of the row of the matrix \code{data} where the points belonging to group i are.
#'    }
#'
#' @return Returns a vector. The component i contains the sum of squared errors  value of group i.
#'
#'
#'
#'
#' @examples
#'
#'#'set.seed(231)
#'data1=gtools::rdirichlet(10,c(1,1,1,4,4))
#'data=t(data1)
#'grouping=list(c(1,2,3),c(4,5))
#'centers=centers_function_mean(data, grouping)
#'FHW_output=list(centers=centers,   grouping=grouping)
#'distance=Euclideandistance
#'
#'ECDentroCluster3(data, FHW_output, distance)
#'
#' @export








ECDentroCluster3<-function(data, FHW_output, distance){
  rownames(data)<-NULL
  colnames(data)<-NULL

  EC=rep(0, length(FHW_output$grouping))
  for (j in 1:length(FHW_output$grouping)){

    PointsGj=FHW_output$grouping[[j]]
    centerGj=FHW_output$centers[j,]

    dm=rep(0,length(PointsGj))
    for (m in 1:length(PointsGj)){
      dm[m]=(distance(as.numeric(data[PointsGj[m], ]),   centerGj))
    }
    EC[j] =sum(dm)

  }

  return(EC)

}
