% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decode.R
\name{s_attribute_decode}
\alias{s_attribute_decode}
\title{Decode Structural Attribute.}
\usage{
s_attribute_decode(
  corpus,
  data_dir,
  s_attribute,
  encoding = NULL,
  registry = Sys.getenv("CORPUS_REGISTRY"),
  method = c("R", "Rcpp")
)
}
\arguments{
\item{corpus}{A CWB corpus (ID in upper case).}

\item{data_dir}{The data directory where the binary files of the corpus are
stored.}

\item{s_attribute}{A structural attribute (length 1 \code{character} vector).}

\item{encoding}{Encoding of the values ("latin-1" or "utf-8")}

\item{registry}{The CWB registry directory.}

\item{method}{A length-one \code{character} vector, whether to use "R" or "Rcpp"
implementation for decoding structural attribute.}
}
\value{
A \code{data.frame} with three columns, if the s-attribute has
values, or two columns, if not. Column \code{cpos_left} are the start
corpus positions of a structural annotation, \code{cpos_right} the end
corpus positions. Column \code{value} is the value of the annotation.
}
\description{
Get \code{data.frame} with left and right corpus positions (cpos) for
structural attributes and values.
}
\details{
Two approaches are implemented: A pure R solution will decode the files
directly in the directory specified by \code{data_dir}. An implementation
using Rcpp will use the registry file for \code{corpus} to find the data
directory.
}
\examples{
# pure R implementation (Rcpp implementation fails on Windows in vanilla mode)
b <- s_attribute_decode(
  corpus = "REUTERS",
  data_dir = system.file(package = "RcppCWB", "extdata", "cwb", "indexed_corpora", "reuters"),
  registry = get_tmp_registry(),
  s_attribute = "places", method = "R"
)

# Using Rcpp wrappers for CWB C code
b <- s_attribute_decode(
  corpus = "REUTERS",
  data_dir = system.file(package = "RcppCWB", "extdata", "cwb", "indexed_corpora", "reuters"),
  s_attribute = "places",
  method = "Rcpp",
  registry = get_tmp_registry()
)
}
