% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grabMzmlFunctions.R
\name{grabMzmlMS3}
\alias{grabMzmlMS3}
\title{Extract the MS3 data from an mzML nodeset}
\usage{
grabMzmlMS3(xml_data, rtrange, file_metadata, incl_polarity)
}
\arguments{
\item{xml_data}{An `xml2` nodeset, usually created by applying `read_xml` to
an mzML file.}

\item{rtrange}{A vector of length 2 containing an upper and lower bound on
retention times of interest. Providing a range here can speed up load times
(although not enormously, as the entire file must still be read) and reduce
the final object's size.}

\item{file_metadata}{Information about the file used to decode the binary
arrays containing m/z and intensity information.}

\item{incl_polarity}{Boolean determining whether the polarity of the scan
should be returned as a column in the table (positive mode = 1, negative
mode = -1)}
}
\value{
A `data.table` with columns for retention time (rt),
MS1 precursor m/z (prepremz), MS2 precursor m/z (premz),
fragment m/z (fragmz), collision energy (voltage), and intensity (int).
}
\description{
Extract the MS3 data from an mzML nodeset
}
