#' @title Phylogenetic Ridge Regression Methods for Comparative Studies
#' @name RRphylo-package
#' @description \pkg{RRphylo} provides tools for phylogenetic comparative
#'   analysis. The main functions allow estimation of phenotypic evolutionary
#'   rates, identification of shifts in rate of evolution, quantification of
#'   direction and size of evolutionary change of multivariate traits, and
#'   computation of species ontogenetic vectors. Additionally, there are
#'   functions for simulating phenotypic data, manipulating phylogenetic trees,
#'   and retrieving information from phylogenies. Finally, there are functions
#'   to plot and test rate shifts at particular nodes.
#' @description The complete list of functions can be displayed with
#'   \code{library(help = RRphylo)}. Citations to individual functions are
#'   available by typing \code{citation("RRphylo")}.
#' @author Pasquale Raia, Silvia Castiglione, Carmela Serio, Alessandro
#'   Mondanaro, Marina Melchionna, Mirko Di Febbraro, Antonio Profico, Francesco
#'   Carotenuto
NULL
