% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{ppl_plot_avg_cdiff}
\alias{ppl_plot_avg_cdiff}
\title{Plots average difference between two conditions.}
\usage{
ppl_plot_avg_cdiff(
  data,
  Column = NULL,
  xlim = NA,
  Averaging = "Subject",
  Condition = NULL,
  CondLabels = NA,
  ErrorBar = TRUE,
  PupilPreTheme = TRUE,
  ConfLev = 95,
  CItype = "simultaneous",
  ErrorBand = FALSE,
  ErrorType = "SE"
)
}
\arguments{
\item{data}{A data table object.}

\item{Column}{A character vector specifying the desired column.}

\item{xlim}{A vector of two integers specifying the limits of the x-axis.}

\item{Averaging}{A character string indicating how the averaging should
be done. "Subject" (default) will produce the grand mean in the data, while
"Item" (or, in principle, any other column name) will
calculate the grand mean by that factor.}

\item{Condition}{A list containing the column name corresponding to the
condition and factor levels to be used for calculating the difference.}

\item{CondLabels}{A named character vector specifying the desired labels
of the levels of the condition.}

\item{ErrorBar}{A logical indicating whether error bars should be
included in the plot.}

\item{PupilPreTheme}{A logical indicating whether the theme included with the
function should be applied, or ggplot2's base theme (to which any other
custom theme could be added).}

\item{ConfLev}{A number indicating the confidence level of the CI.}

\item{CItype}{A string indicating "simultaneous" or "pointwise". Simultaneous
performs a Bonferroni correction for the interval.}

\item{ErrorBand}{A logical indicating whether error bands should be
included in the plot.}

\item{ErrorType}{A string indicating "SE" or "CI".}
}
\value{
Nothing.
}
\description{
\code{ppl_plot_avg_cdiff} calculates the average of differences between
two specified conditions along with standard error and then plots the
results.
}
\examples{
# Load example data
data("Pupilex7")

ppl_plot_avg_cdiff(data = Pupilex7, Column = "Pupil",
                   Condition = list(talker = c("EN3", "CH1")),
                   ErrorBar = TRUE, PupilPreTheme = TRUE)

# Please see the vignettes for detailed example usage.
# vignette("PupilPre_Plotting", package="PupilPre")

}
