% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profileGLMM_postProcess.R
\name{profileGLMM_postProcess}
\alias{profileGLMM_postProcess}
\title{Post-process the MCMC chain from profileGLMM_Gibbs}
\usage{
profileGLMM_postProcess(
  MCMC_Obj,
  modeClus = "NG",
  comp_cooc = TRUE,
  alpha = 0.05
)
}
\arguments{
\item{MCMC_Obj}{Profile GLMM MCMC output of the \code{profileGLMM_Gibbs} function. This object must contain the raw MCMC samples for fixed effects (\code{beta}), cluster assignments (\code{Z}), cluster parameters (\code{pvec}, \code{muClus}, \code{PhiClus}), outcome effects (\code{gamma}), and names (\code{names}).}

\item{modeClus}{A character string specifying the clustering method to determine the representative partition. Options are \code{'NG'} (Ng's spectral clustering, default) or \code{'LS'} (Least Squares clustering).}

\item{comp_cooc}{A logical value. If \code{TRUE} (default), the co-occurrence matrix is computed and clustering is performed to find a representative partition. If \code{FALSE}, only the population parameters are processed.}

\item{alpha}{A numeric value between 0 and 1, specifying the significance level for calculating the posterior credible intervals (CIs) of the fixed effects. Defaults to \code{0.05} (yielding 95\% CIs).}
}
\value{
A list with three elements:
\describe{
  \item{\code{coocMat}:}{ The co-occurrence matrix of the MCMC cluster assignments (\code{MCMC_Obj$Z}).}
  \item{\code{clust}:}{ A list containing the results of the representative clustering (if \code{comp_cooc = TRUE}), including the optimal partition (\code{Zstar}), number of clusters (\code{Kstar}), representative cluster parameters (\code{cen}, \code{pvec}, \code{gamma}), and full posterior samples for the cluster characteristics.}
  \item{\code{pop}:}{ A list containing the posterior mean and \code{(1-alpha)} credible intervals for the fixed effects (\code{betaFE}).}
}
}
\description{
This function performs essential post-processing of the MCMC output generated by the \code{profileGLMM_Gibbs} function. It calculates the posterior means and credible intervals for the fixed effects (population parameters) and, optionally, computes a representative cluster partition using methods like Least Squares (LS) or Ng's spectral clustering (NG) on the co-occurrence matrix. It also provides estimated cluster characteristics (centroids, probability vectors, and outcome effects) for the representative partition.
}
\examples{
# Load MCMC_Obj, the result of profileGLMM_Gibbs()
data("examp")
MCMC_Obj = examp$MCMC_Obj
post_Obj = profileGLMM_postProcess(MCMC_Obj, modeClus='LS')
print(post_Obj$pop$betaFE)
}
