SF36rec <- function(x,name){

  if (is.numeric(x)){
  }else{
    stop("x must be numeric")
  }

  if (max(x)>100 | min(x)<0){
    stop("x must be bounded between 0 and 100")
  }

  if (name%in%c("PF","RP","BP","GH","VT","SF","RE","MT")){
  } else{
    stop("the dimension name no identificable, options are PF, RP, BP, GH, VT, SF, RE or MT")
  }

  if (name=="PF"){
    # Physical Functioning
    out <- recode(x, "0:2.5=0; 2.5:7.5=1; 7.5:12.5=2; 12.5:17.5=3; 17.5:22.5=4;
                  22.5:27.5=5; 27.5:32.5=6; 32.5:37.5=7; 37.5:42.5=8; 42.5:47.5=9;
                  47.5:52.5=10; 52.5:57.5=11; 57.5:62.5=12; 62.5:67.5=13; 67.5:72.5=14;
                  72.5:77.5=15; 77.5:82.5=16; 82.5:87.5=17; 87.5:92.5=18; 92.5:97.5=19;
                  97.5:100=20")
  }

  if (name=="RP"){
    # Role Physical
    out <- recode(x,"0:12.5=0 ; 12.5:37.5=1 ; 37.5:62.5=2 ; 62.5:87.5=3 ;
                  87.5:100=4")
  }

  if (name=="BP"){
    # Bodily Pain
    out <- recode(x, "0:5=0; 5:16=1; 16:26=2; 26:36=3; 36:47=4; 47:57=5; 57:67=6;
                  67:77=7; 77:92=8; 92:100=9")
  }

  if (name=="GH"){
    # General Health
    out <- recode(x, "0:2.5=0; 2.5:7.5=1; 7.5:13.5=2; 13.5:18.5=3; 18.5:23.5=4;
                  23.5:28.5=5; 28.5:33.5=6; 33.5:38.5=7; 38.5:43.5=8; 43.5:48.5=9;
                  48.5:53.5=10; 53.5:58.5=11; 58.5:63.5=12; 63.5:68.5=13; 68.5:73.5=14;
                  73.5:78.5=15; 78.5:83.5=16; 83.5:88.5=17; 88.5:93.5=18; 93.5:98.5=19;
                  98.5:100=20")
  }

  if (name=="VT"){
    # Vitality
    out <- recode(x, "0:2.5=0; 2.5:7.5=1; 7.5:12.5=2; 12.5:17.5=3; 17.5:22.5=4;
                  22.5:27.5=5; 27.5:32.5=6; 32.5:37.5=7; 37.5:42.5=8; 42.5:47.5=9;
                  47.5:52.5=10; 52.5:57.5=11; 57.5:62.5=12; 62.5:67.5=13; 67.5:72.5=14;
                  72.5:77.5=15; 77.5:82.5=16; 82.5:87.5=17; 87.5:92.5=18; 92.5:97.5=19;
                  97.5:100=20")
  }

  if (name=="SF"){
    # Social Functioning
    out <- recode(x, "0:6.25=0; 6.25:18.75=1; 18.75:31.25=2; 31.25:43.75=3;
                  43.75:56.25=4; 56.25:68.75=5; 68.75:81.25=6; 81.25:93.75=7;
                  93.75:100=8")
  }

  if (name=="RE"){
    # Role Emotional
    out <- recode(x,"0:16.67=0 ; 16.67:50=1 ; 50:83.33=2 ; 83.33:100=3")
  }

  if (name=="MH"){
    # Mental Health
    out <- recode(x, "0:2=0;2:10=1;10:18=2;18:26=3;26:34=4;34:42=5;42:50=6;
                       50:58=7;58:66=8;66:74=9;74:82=10;82:90=11;90:98=12;98:100=13")
  }


  return(out)
}
