% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PERSUADE_S3_method.R
\name{summary.PERSUADE}
\alias{summary.PERSUADE}
\title{Summary Method for PERSUADE Objects}
\usage{
\method{summary}{PERSUADE}(object, ..., type = "km")
}
\arguments{
\item{object}{A PERSUADE object from \code{f_PERSUADE()}.}

\item{...}{Additional arguments. Currently only \code{type} is used.}

\item{type}{Character string, one of "km", "surv_probs", "gof",
"gof_spline", "gof_cure". Controls the type of summary output.}
}
\value{
A data frame or list of data frames depending on \code{type}.
}
\description{
The \code{type} argument controls which summary is produced:
\itemize{
\item \code{"km"}: Kaplan-Meier estimates (default).
\item \code{"surv_probs"}: Survival probabilities at specified prediction times for each group.
\item \code{"gof"}: Goodness-of-fit statistics for standard parametric models.
\item \code{"gof_spline"}: Goodness-of-fit statistics for spline models.
\item \code{"gof_cure"}: Goodness-of-fit statistics for cure models (including cure fraction).
}
}
\examples{
\donttest{
years <- survival::lung$time
status <-  survival::lung$status
group <- factor(survival::lung$sex)
PERSUADE <- f_PERSUADE(
  name = "Example",
  years = years,
  status = status,
  group = group,
  strata = FALSE,
  spline_mod = FALSE,
  cure_mod = FALSE,
  time_unit = 365.25/12,
  time_horizon = 2000,
  time_pred_surv_table = seq(0, 2000, 365.25)
)
summary(PERSUADE, type = "surv_probs")
}

}
