% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimation.R
\name{default_envir}
\alias{default_envir}
\alias{BiCopCondFit}
\alias{ComputeCondMargin}
\title{Fits the copula joining w and v given cond_set abiding
by the conditional independencies of the graph}
\usage{
default_envir()

BiCopCondFit(
  data,
  DAG,
  v,
  w,
  cond_set,
  familyset,
  order_hash,
  e,
  verbose = 1,
  method
)

ComputeCondMargin(
  data,
  DAG,
  v,
  cond_set,
  familyset,
  order_hash,
  e,
  verbose = 1,
  method = method
)
}
\arguments{
\item{data}{data frame}

\item{DAG}{Directed Acylic Graph}

\item{v, w}{nodes of the graph}

\item{cond_set}{vector of nodes of DAG. They should all be parents of v.
They should be ordered from the smallest to the biggest.}

\item{familyset}{vector of copula families}

\item{order_hash}{hashmap of parental orders}

\item{e}{environment containing all the hashmaps}

\item{verbose}{if \code{0}, don't print anything.
If \code{verbose >= 1}, print information about the fitting procedure.}

\item{method}{indicates the estimation method (\code{"mle"} for maximum
likelihood estimation or \code{"itau"} of inversion of Kendall's tau)}
}
\value{
\code{default_envir} returns an environment to be passed
to \code{BiCopCondFit} or to \code{ComputeCondMargin}. \code{BiCopCondFit}
returns the fitted copula object of \code{v}, \code{w} given \code{cond_set}.
\code{ComputeCondMargin} returns the fitted conditional margins of \code{v}
given \code{cond_set}.

Both functions store all intermediary results in \code{e} to save computation
time.
}
\description{
Fits the copula joining w and v given cond_set abiding
by the conditional independencies of the graph
}
\examples{

DAG = create_empty_DAG(3)
DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
DAG = bnlearn::set.arc(DAG, 'U2', 'U3')

order_hash = r2r::hashmap()
order_hash[['U3']] = c("U1", "U2")

fam = matrix(c(0, 0, 1,
               0, 0, 1,
               0, 0, 0), byrow = TRUE, ncol = 3)

tau = 0.2 * fam

my_PCBN = new_PCBN(
  DAG, order_hash,
  copula_mat = list(tau = tau, fam = fam))

mydata = PCBN_sim(my_PCBN, N = 5)
e = default_envir()
ls(e)
C_13 = BiCopCondFit(data = mydata, DAG = DAG, v = "U1", w = "U3",
                    cond_set = c(), familyset = 1, order_hash = order_hash,
                    e = e, method = "mle")

C_23_1 = BiCopCondFit(data = mydata, DAG = DAG, v = "U2", w = "U3",
                      cond_set = "U1", familyset = 1, order_hash = order_hash,
                      e = e, method = "itau")

U_2_13 = ComputeCondMargin(data = mydata, DAG = DAG,
                           v = "U2", cond_set = c("U1", "U3"),
                           familyset = 1, order_hash = order_hash, e = e,
                           method = "mle")

}
